﻿using System.Collections.ObjectModel;

namespace SfRotatorMaui
{
    public class MainViewModel : PropertyChangedNotifier
    {
        public ObservableCollection<MyModel> MyModels { get; } = new ObservableCollection<MyModel>();

        public MainViewModel()
        {
            //This works fine
            AddModel(null);
            AddModel(null);
            AddModel(null);

            //Later added models doesn't work
            _timer = new Timer(AddModel, null, TimeSpan.FromSeconds(3), TimeSpan.FromSeconds(3));
        }

        private void AddModel(object? state)
        {
            MainThread.BeginInvokeOnMainThread(() =>
            {
                _counter++;
                MyModels.Add(new MyModel($"Model{_counter}", $"Description{_counter}"));

                OnPropertyChanged(nameof(MyModels)); //Doesn't help too
            });
        }

        private int _counter = 0;
        private readonly Timer _timer;
    }
}
