using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using BlazorDataGridSQLNet8.Data;

namespace BlazorDataGridSQLNet8.Data
{ 
	public class OrderContext : DbContext
    {
        public virtual DbSet<Order> Orders { get; set; }


        private readonly IConfiguration _configuration;

        public OrderContext()
        {
            // Default constructor with a default connection string
            var builder = new ConfigurationBuilder()
                .SetBasePath(AppDomain.CurrentDomain.BaseDirectory)
                .AddJsonFile("appsettings.json");

            _configuration = builder.Build();
        }

		public OrderContext(DbContextOptions<OrderContext> options, IConfiguration configuration)
		   : base(options)
		{
			_configuration = configuration;
		}

		protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            if (!optionsBuilder.IsConfigured)
            {

                optionsBuilder.UseSqlServer(_configuration.GetConnectionString("LibraryDatabase"));
            }
        }
    }
 }
