﻿using System.Linq;
using System;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using BlazorDataGridSQLNet8.Data;

namespace BlazorDataGridSQLNet8.Data
{
   public class DataGridService
   {
         OrderContext db=new OrderContext();
		 
        //To Get all Order details   
        public DbSet<Order> GetAllOrder()
        {
            try
            {
                return db.Orders;
            }
            catch
            {
                throw;
            }
        }
       // To Add new Data record
        public void AddOrder(Order Data)
        {
            try
            {
                db.Orders.Add(Data);
                db.SaveChanges();
            }
            catch
            {
                throw;
            }
        }

        //To Update the records of a particluar Data    
         public void UpdateOrder(Order Data)
        {
            try
            {
                var data = db.Orders.Where(x => x.OrderID == Data.OrderID).SingleOrDefault();
                data!.OrderID=Data.OrderID;
                data!.CustomerID=Data.CustomerID;
                data!.EmployeeID=Data.EmployeeID;
                data!.ShipCountry=Data.ShipCountry;
                data!.ShipAddress=Data.ShipAddress;
                data!.ShipName=Data.ShipName;
                data!.ShipCity=Data.ShipCity;
		   
			  
               db.SaveChanges();
            }
            catch
            {
                throw;
            }
        }

        //To Delete the record of a particular Data
         public void DeleteOrder(int value)
         {
           try
           {
             Order? data = db.Orders.Find(value);
            db.Orders.Remove(data!);
            db.SaveChanges();
           }
           catch
           {
             throw;
            }
          }

        //Get the details of a particular Data    
        public Order GetOrderData(int id)
        {
            try
            {
                Order? Data = db.Orders.Find(id);
                return Data!;
            }
            catch
            {
                throw;
            }
        }
    }
   
}