﻿using System.Diagnostics.CodeAnalysis;
using Microsoft.AspNetCore.Components;
using Syncfusion.Blazor.DropDowns;

namespace BlazorApp1.Pages;


public partial class SubjekatRadioSelectComponent
{
    [Parameter, AllowNull]
    public EventCallback<string?> ChangeNaziv { get; set; }
    [Parameter] public EventCallback OnRefresh { get; set; }
    [Parameter] public EventCallback OnLoaded { get; set; }

    [Parameter, AllowNull]
    public ISelectableSubject SelectableSubject { get; set; }
	[Parameter, AllowNull]
	public CustomCreateRadniNalog? CustomCreateRadniNalog { get; set; }
	[AllowNull]
    private string PodnosilacStringChecked { get; set; } = "PravnoLice";
    private bool BindVisibleDialog { get; set; }
    private int? SubjekatId { get; set; }
    private async void OnRadioClicked()
    {
    }
    private Dictionary<string, object> btnAttr = new Dictionary<string, object>()
    {
        {"type","button" }
    };
    private void ClickedAddSubjekat()
    {
        BindVisibleDialog = true;
    }
    private void ClickedEditSubjekat()
    {
        SubjekatId = SelectableSubject.SubjekatId;
        BindVisibleDialog = true;
    }

    async Task SubjekatChangeHandler(int subjekatId)
    {
        if (subjekatId != SelectableSubject.SubjekatId)
        {
        }
        CloseDialog();
        SelectableSubject.SubjekatId = subjekatId;
        StateHasChanged();
    }
    public void CloseDialog()
    {
        BindVisibleDialog = false;
        StateHasChanged();
    }
}

public interface ISelectableSubject
{
    int? SubjekatId { get; set; }
    int? LiceId { get; set; }
    int? OrganId { get; set; }
}
