﻿using Microsoft.AspNetCore.Components;
using Microsoft.Extensions.Localization;
using Syncfusion.Blazor.DropDowns;
using Syncfusion.Blazor.Popups;

namespace BlazorApp1.Pages;

public partial class SubjekatFormComponent
{
	[Parameter]
	public int? SubjekatId { get; set; }
	[Parameter]
	public EventCallback<int> RefreshParent { get; set; }
	public Subjekat Subjekat { get; set; } = new();
	private async Task OnSubmit()
	{
		if (SubjekatId == null)
		{
			await AddSubjekat();
			await RefreshParent.InvokeAsync(Subjekat.Id);
		}
		else
		{
			await EditSubjekat();
		}
	}
	private async Task AddSubjekat()
	{
		BlazorApp1.Data.Subjekati.Subjekti.Add(Subjekat);
	}

	private async Task EditSubjekat()
	{
	}
}
