﻿using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Diagnostics.CodeAnalysis;

namespace BlazorApp1.Pages
{
	[NotMapped]
	public class CustomCreateRadniNalog : ISelectableSubject
	{
		[NotMapped]
		//[Required(ErrorMessageResourceName = "required")]
		public string Naziv { get; set; }

		[NotMapped, AllowNull]
		[RequiredOneOf("SubjekatId", "LiceId", "OrganId")]
		public int? SubjekatId { get; set; }
		[NotMapped, AllowNull]
		[RequiredOneOf("SubjekatId", "LiceId", "OrganId")]
		public int? LiceId { get; set; }
		[NotMapped, AllowNull]
		[RequiredOneOf("SubjekatId", "LiceId", "OrganId")]
		public int? OrganId { get; set; }
	}

	public class RequiredOneOfAttribute : ValidationAttribute
	{
		private readonly string[] propertyNames;

		public RequiredOneOfAttribute(params string[] propertyNames)
		{
			this.propertyNames = propertyNames;
		}

		protected override ValidationResult? IsValid(object? value, ValidationContext validationContext)
		{
			bool atLeastOnePropertyHasValue = false;
			var memberName = validationContext.MemberName;

			foreach (var propertyName in propertyNames)
			{
				var propertyInfo = validationContext.ObjectType.GetProperty(propertyName);
				if (propertyInfo == null)
				{
					continue;
				}

				var propertyValue = (int?)propertyInfo.GetValue(validationContext.ObjectInstance);

				if (propertyValue.HasValue)
				{
					atLeastOnePropertyHasValue = true;
					break;
				}
			}

			if (atLeastOnePropertyHasValue)
			{
				return ValidationResult.Success;
			}
			else
			{
				return new ValidationResult("Validation_required", new[] { memberName ?? "" });
			}
		}
	}
}

