﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.OData.Deltas;
using Microsoft.AspNetCore.OData.Query;
using Microsoft.AspNetCore.OData.Routing.Controllers;
using Microsoft.Extensions.Logging;
using DemoFail.Shared;
using System;
using System.Linq;
using System.Security.Claims;
using System.Threading;
using Microsoft.AspNetCore.Cors;
using System.Text;
using Syncfusion.Blazor.Gantt;

namespace DemoFail.Server.Controllers
{
    //[Authorize]
    //[ApiController]
    //[Route("OrgUnits")]
    public class OrgUnitsController : ODataController
    {
        public OrgUnitsController() 
        { 
        
        }

        //private static OrgUnit[] Complex = new OrgUnit[] {}

        public static List<OrgUnit> orgUnits = new List<OrgUnit>();
        public void GetData()
        {
            if (orgUnits.Count == 0)
            {
                orgUnits.Add(new OrgUnit() { Id = 1, HasChild = true});
                orgUnits.Add(new OrgUnit() { Id = 2, ParentId = 11, Summary = "Ou 2", VechicleMake = new VechicleMake() { ID = 23, Summary = new Summary() { ID1 = 34 } } });
                orgUnits.Add(new OrgUnit() { Id = 3, ParentId = 12, Summary = "Ou 3", VechicleMake = new VechicleMake() { ID = 24, Summary = new Summary() { ID1 = 35 } } });
                orgUnits.Add(new OrgUnit() { Id = 4, ParentId = 13, Summary = "Ou 4", VechicleMake = new VechicleMake() { ID = 25, Summary = new Summary() { ID1 = 36 } } });
                orgUnits.Add(new OrgUnit() { Id = 5, ParentId = 14, Summary = "Ou 5", VechicleMake = new VechicleMake() { ID = 26, Summary = new Summary() { ID1 = 37 } } });
                orgUnits.Add(new OrgUnit() { Id = 6, ParentId = 15, Summary = "Ou 6", VechicleMake = new VechicleMake() { ID = 27, Summary = new Summary() { ID1 = 38 } } });
            }
            var distinctVehicleMakeIds = orgUnits
       .Where(o => o.VechicleMake != null)
       .Select(o => o.VechicleMake.ID)
       .Distinct()
       .ToList();
        }


        //[HttpGet]
        [EnableQuery]
        public IActionResult Get(CancellationToken token)
        {
            GetData();
            IQueryable<OrgUnit> tOrgUnits = orgUnits.AsQueryable();
            return Ok(tOrgUnits);
        }

        [EnableQuery]
        [HttpGet]
        public IActionResult Get(int key)
        {
            var product = orgUnits.FirstOrDefault(p => p.Id == key);
            if (product == null)
            {
                return NotFound($"Not found product with id = {key}");
            }

            return Ok(product);
        }

        [HttpPost]
        // [EnableQuery]
        public IActionResult Post([FromBody] OrgUnit orgUnit, CancellationToken token)
        {
            orgUnits.Add(orgUnit);

            //_context.SaveChanges();

            return Created(orgUnit);
        }

        [HttpPut]
        public IActionResult Put(int key, [FromBody] Delta<OrgUnit> orgUnit)
        {
            var original = orgUnits.FirstOrDefault(p => p.Id == key);
            if (original == null)
            {
                return NotFound($"Not found product with id = {key}");
            }

            orgUnit.Put(original);
            //_context.SaveChanges();
            return Updated(original);
        }

        [HttpPatch]
        public IActionResult Patch(int key, Delta<OrgUnit> orgUnit)
        {
            var original = orgUnits.FirstOrDefault(p => p.Id == key);
            if (original == null)
            {
                return NotFound($"Not found product with id = {key}");
            }

            orgUnit.Patch(original);

            //_context.SaveChanges();

            return Updated(original);
        }

        [HttpDelete]
        public IActionResult Delete(int key)
        {
            var original = orgUnits.FirstOrDefault(p => p.Id == key);
            if (original == null)
            {
                return NotFound($"Not found product with id = {key}");
            }

            orgUnits.Remove(original);
            //_context.SaveChanges();
            return Ok();
        }
    }
}
