﻿using Extensions;
using Grid_Excel_Export.Data;
using Syncfusion.Blazor;

namespace Adaptors
{
    public class OrderAdaptor : DataAdaptor
    {
        private readonly CancellationTokenSource cts = new();

        private IQueryable<Order>? dataSource;

        protected override void OnInitialized()
        {
            dataSource = new List<Order>()
            {
                new() { OrderID = 1000, CustomerID = "ALFKI", Freight = 3, OrderDate = DateTime.Now.AddDays(-10) },
                new() { OrderID = 1001, CustomerID = "ANANTR", Freight = 2, OrderDate = DateTime.Now.AddDays(-5) },
                new() { OrderID = 1002, CustomerID = "ANTON", Freight = 4, OrderDate = DateTime.Now.AddDays(-6) },
                new() { OrderID = 1003, CustomerID = "BLONP", Freight = 2, OrderDate = DateTime.Now.AddDays(-8) },
                new() { OrderID = 1004, CustomerID = "698.4", Freight = 6, OrderDate = DateTime.Now.AddDays(-15) },
                new() { OrderID = 1005, CustomerID = "BLONP", Freight = 5, OrderDate = DateTime.Now.AddDays(-13) },
                new() { OrderID = 1006, CustomerID = "BOLID", Freight = 8, OrderDate = DateTime.Now.AddDays(-17) },
            }
            .AsQueryable();
        }

        public override async Task<object> ReadAsync(DataManagerRequest dm, string? key = null)
        {
            return await dm.ReadDataAsync(dataSource!, cancellationToken: cts.Token);
        }
    }
}
