﻿using System.ComponentModel;
using System.Net.Http.Headers;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Http.Features;
using Microsoft.AspNetCore.Mvc;
using IHostingEnvironment = Microsoft.AspNetCore.Hosting.IHostingEnvironment;

namespace BlazorServerProject.Data
{
    [Route("api/[controller]")]
    [ApiController]
    public class SampleController : ControllerBase
    {
        private Microsoft.AspNetCore.Hosting.IHostingEnvironment hostingEnv;

        public int? ddlIndex { get; set; } = 1;

        public SampleController(IHostingEnvironment env)
        {
            this.hostingEnv = env;
        }

        public class UserModel
        {
            public string Id { get; set; }
            public string Username { get; set; }
            // Add more properties as needed (e.g., email, role, etc.)
        }



        public class UserService
        {
            // Simulating data storage; replace this with actual data access logic
            private List<UserModel> users = new List<UserModel>
            {
                new UserModel { Id = "1", Username = "user1" },
                new UserModel { Id = "2", Username = "user2" },
                // Add more users as needed
            };

            public async Task<UserModel> Search(string id)
            {
                // Simulating an asynchronous operation; replace this with actual async logic
                await Task.Delay(100); // Simulate delay

                return users.FirstOrDefault(user => user.Id == id);
            }
        }

        public class Country
        {
            public string Name { get; set; }
            public string Code { get; set; }
        }

        public class ViewModel
        {
            public List<Country> Countries { get; set; }
            public string SelectedCountry { get; set; } = "Code1";

            public ViewModel()
            {
                Countries = new List<Country>
                    {
                        new Country { Name = "Country 1", Code = "Code1" },
                        new Country { Name = "Country 2", Code = "Code2" },
                        new Country { Name = "Country 3", Code = "Code3" }
                    };
            }
        }

        
    }
}


