using Microsoft.AspNetCore.Components.Web;
using Microsoft.AspNetCore.Components.WebAssembly.Hosting;
using Syncfusion.Blazor;
using System.Globalization;
using TestCulture.Client;

var builder = WebAssemblyHostBuilder.CreateDefault(args);
builder.RootComponents.Add<App>("#app");
builder.RootComponents.Add<HeadOutlet>("head::after");

builder.Services.AddScoped(sp => new HttpClient { BaseAddress = new Uri(builder.HostEnvironment.BaseAddress) });
//Syncfusion support
builder.Services.AddSyncfusionBlazor();


CultureInfo.DefaultThreadCurrentCulture = new CultureInfo("en-GH");
CultureInfo.DefaultThreadCurrentUICulture = new CultureInfo("en-GH");
await builder.Build().RunAsync();
