﻿// See https://aka.ms/new-console-template for more information
using Syncfusion.XlsIO;
using System.Diagnostics;

Data testData = new Data();
testData.Field1 = "Field1";
testData.Field2 = "Field2";
testData.Field3 = new DateTime(2024, 2, 4, 8, 0, 0);
testData.Field4 = new DateTime(2024, 2, 4, 9, 0, 0);
testData.Field5 = new DateTime(2024, 2, 4, 20, 0, 0);
testData.Field6 = new DateTime(2024, 2, 4, 21, 0, 0);

MemoryStream ms = new MemoryStream();
using (FileStream file = new FileStream(@"..\..\..\Template.xlsx", FileMode.Open, FileAccess.Read))
    file.CopyTo(ms);
ms.Seek(0, SeekOrigin.Begin);

MemoryStream response = new MemoryStream();
using (ExcelEngine excelEngine = new ExcelEngine())
{
    var xl = excelEngine.Excel.Workbooks.Open(ms);
    var ws = xl.Worksheets["Dati"];

    ws[3, 2].Value = testData.Field1;
    ws[3, 3].Value = testData.Field2;
    ws[3, 6].Value2 = testData.Field3;
    ws[3, 7].Value2 = testData.Field4;
    ws[3, 8].Value2 = testData.Field5;
    ws[3, 9].Value2 = testData.Field6;

    Debug.WriteLine(ws.Range[3, 6].DisplayText);
    Debug.WriteLine(ws.Range[3, 7].DisplayText);
    Debug.WriteLine(ws.Range[3, 8].DisplayText);
    Debug.WriteLine(ws.Range[3, 9].DisplayText);

    xl.BuiltInDocumentProperties.CreationDate = DateTime.Now;
    xl.BuiltInDocumentProperties.LastSaveDate = DateTime.Now;

    response.Seek(0, SeekOrigin.Begin);
    response.SetLength(0);
    xl.SaveAs(response);
    response.Seek(0, SeekOrigin.Begin);
}

MemoryStream imageStream = new MemoryStream();
using (Syncfusion.XlsIO.ExcelEngine excelEngine = new Syncfusion.XlsIO.ExcelEngine())
{
    var xl = excelEngine.Excel.Workbooks.Open(response);
    Syncfusion.XlsIO.IApplication application = excelEngine.Excel;
    //Initialize XlsIORenderer
    application.XlsIORenderer = new Syncfusion.XlsIORenderer.XlsIORenderer();
    Syncfusion.XlsIO.ExportImageOptions o = new Syncfusion.XlsIO.ExportImageOptions();
    o.ScalingMode = Syncfusion.XlsIO.ScalingMode.Normal;
    o.ImageFormat = Syncfusion.XlsIO.ExportImageFormat.Jpeg;
    //parto dalla seconda riga, che la prima è vuota
    xl.Worksheets[0].ConvertToImage(2, 1, 4, 26, o, imageStream);
    imageStream.Seek(0, SeekOrigin.Begin);
}

using (var writeStream = File.Create(@"..\..\..\image.jpeg"))
{
    imageStream.CopyTo(writeStream);
}

class Data
{ 
    public string Field1 { get; set; }
    public string Field2 {  get; set; }
    public DateTime Field3 {  get; set; } 
    public DateTime Field4 {  get; set; }
    public DateTime Field5 {  get; set; }
    public DateTime Field6 {  get; set; }
}