﻿using System.Text.Json.Serialization;

namespace Shared;

public class MeterReportData
{
	public short MeterId { get; set; }

	public string MeterName { get; set; } = string.Empty;

	public string Period { get; set; } = string.Empty;

	/// <summary>
	/// Indicates to the client that the data is filtered by date range on the server, only used for half hour data.
	/// </summary>
	public DateOnly? DateFrom { get; set; }

	/// <summary>
	/// Indicates to the client that the data is filtered by date range on the server, only used for half hour data.
	/// </summary>
	public DateOnly? DateTo { get; set; }

	/// <summary>
	/// Gets or sets the data, will only be filtered by date range if the period is half hour.
	/// </summary>
	public List<MeterDataPoint> Data { get; set; } = [];

	public DateTime? AllTimeMin { get; set; }

	public DateTime? AllTimeMax { get; set; }

	public int? AllTimeCount { get; set; }

	public int SourceCode { get; set; }

	public string SourceDescription { get; set; } = string.Empty;

	public string SourceShortName { get; set; } = string.Empty;

	public int Exponent { get; set; }

	// TODO: Need a list of symbol by ratio so we can dynamically change the units displayed.
	public string? Symbol { get; set; }

	public string? CurrencySymbol { get; set; }

	public string? CurrencyCode { get; set; }

	public DateTime LoadedFromSourceOn { get; set; } = DateTime.Now;

	public byte MeterRatio { get; set; }

	[JsonIgnore]
	public decimal ValueDivider => Convert.ToDecimal(Math.Pow(10, MeterRatio));

	[JsonIgnore]
	public DateOnly LoadedFromSourceDateOnly => DateOnly.FromDateTime(LoadedFromSourceOn);

	//public DateTime? GetFilterMinDate()
	//{
	//	if (this.AllTimeMin == null)
	//	{
	//		return null;
	//	}

	//	var min = this.AllTimeMin.Value;

	//	return this.Period switch
	//	{
	//		MeterPeriods.Month => (DateTime?)new DateTime(min.Year, min.Month, 1),
	//		MeterPeriods.Year => (DateTime?)new DateTime(min.Year, 1, 1),
	//		_ => (DateTime?)min,
	//	};
	//}

	//public DateTime? GetFilterMaxDate()
	//{
	//	if (this.AllTimeMax == null)
	//	{
	//		return null;
	//	}

	//	var max = this.AllTimeMax.Value;

	//	return max;

	//	//return this.Period switch
	//	//{
	//	//	MeterPeriods.Month => (DateTime?)new DateTime(max.Year, max.Month, 1),
	//	//	MeterPeriods.Year => (DateTime?)new DateTime(max.Year, 1, 1),
	//	//	_ => (DateTime?)max,
	//	//};
	//}
}
