﻿using System.Text.Json.Serialization;

namespace Shared;

public class MeterDataPoint
{
	public required DateTime Date { get; set; }

	public decimal? Value { get; set; }

	/// <summary>
	/// This is the value that will be displayed in the chart, the value divided by the unit factor.
	/// Set before drawing the data in case we want to dynamically change the unit.
	/// </summary>
	[JsonIgnore]
	public decimal? DisplayValue { get; set; } = null;

	public decimal? TargetValue { get; set; }

	/// <summary>
	/// This is the value that will be displayed in the chart, the value divided by the unit factor.
	/// Set before drawing the data in case we want to dynamically change the unit.
	/// </summary>
	[JsonIgnore]
	public decimal? DisplayTargetValue { get; set; }

	public decimal? ValueMoney { get; set; }

	public decimal? TargetValueMoney { get; set; }

	public decimal? ValueCO2 { get; set; }

	public decimal? TargetValueCO2 { get; set; }

	public decimal? DegreeDayHeat { get; set; }

	public decimal? DegreeDayCool { get; set; }

	public int? WeekNumber { get; set; }

	public void SetTargetValues(
		//MeterProfileModel meterProfile,
		decimal? dayTargetValue,
		decimal? dayTargetCO2e,
		decimal? dayValueMoney)
	{
		var timeOfDay = TimeOnly.FromDateTime(this.Date);
		var targetMultiplier = 1.1m; //meterProfile.TargetMultipliers[timeOfDay];

		if (dayTargetValue.HasValue)
			this.TargetValue = dayTargetValue * targetMultiplier;

		if (dayTargetCO2e.HasValue)
			this.TargetValueCO2 = dayTargetCO2e * targetMultiplier;

		if (dayValueMoney.HasValue)
			this.TargetValueMoney = dayValueMoney * targetMultiplier;
	}

	public override string ToString()
	{
		return $"Date: {Date}, Value: {Value}, TargetValue: {TargetValue}";
	}
}