﻿using CommunityToolkit.Mvvm.ComponentModel;

namespace TestSfNumeric
{
    public partial class MainPage : ContentPage
    {
        int count = 0;

        public static readonly BindableProperty SomeValueProperty =
            BindableProperty.Create(nameof(SomeValue), typeof(int?), typeof(MainPage)); 

        public int? SomeValue
        {
            get => (int?)GetValue(SomeValueProperty);
            set => SetValue(SomeValueProperty, value);
        }

        public MainPage()
        {
            InitializeComponent();
            this.BindingContext = this;
        }

        private void OnCounterClicked(object sender, EventArgs e)
        {
            count++;

            if (count == 1)
                CounterBtn.Text = $"Clicked {count} time";
            else
                CounterBtn.Text = $"Clicked {count} times";

            SemanticScreenReader.Announce(CounterBtn.Text);
        }
    }

}
