﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SyncfusionExamples.Shared
{
    public class OrderStatus
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public long OrderStatusId { get; set; }
        public string? Status { get; set; }
        public bool? IsCompleted { get; set; }

        public virtual ICollection<Order>? Orders { get; set; }

    }

    public class Order
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public long OrderId { get; set; }
        public long OrderStatusId { get; set; }
        public string? CustomerName { get; set; }
        public string? Name { get; set; }
        public bool? NewCustomer { get; set; }

        [ForeignKey("OrderStatusId")]
        public virtual OrderStatus? OrderStatuses { get; set; }
       
    }

    

}
