using Microsoft.AspNetCore.OData;
using Microsoft.AspNetCore.OData.Batch;
using Microsoft.EntityFrameworkCore;
using SyncfusionExamples.Shared;

var builder = WebApplication.CreateBuilder(args);

builder.Services.AddDbContext<AppDbContext>(opts => opts.UseInMemoryDatabase("test"));

// swagger
builder.Services.AddSwaggerGen();

// Add services to the container.
builder.Services.AddControllers()
                .AddOData(opt => opt.AddRouteComponents("odata", ODataEDM.GetEdmModel(), new DefaultODataBatchHandler())
                    .Select()
                    .OrderBy()
                    .Filter()
                    .SkipToken()
                    .SetMaxTop(null)
                    .Expand()
                    .Count());



builder.Services.AddControllersWithViews();
builder.Services.AddRazorPages();



var app = builder.Build();

// Configure the HTTP request pipeline.
if (app.Environment.IsDevelopment())
{
    app.UseWebAssemblyDebugging();
}
else
{
    app.UseExceptionHandler("/Error");
}
app.UseSwagger();
app.UseSwaggerUI(c =>
{
    c.SwaggerEndpoint("/swagger/v1/swagger.json", "Sf Test App API v1");
});
app.UseBlazorFrameworkFiles();
app.UseStaticFiles();

app.UseRouting();
app.UseEndpoints(endpoints =>
{
    endpoints.MapControllers();
});
//app.UseODataRouteDebug();
app.UseODataQueryRequest();
app.UseODataBatching();

app.MapRazorPages();
app.MapControllers();
app.MapFallbackToFile("index.html");

app.Run();
