﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.OData.Deltas;
using Microsoft.AspNetCore.OData.Formatter;
using Microsoft.AspNetCore.OData.Query;
using Microsoft.AspNetCore.OData.Results;
using Microsoft.AspNetCore.OData.Routing.Controllers;
using Microsoft.EntityFrameworkCore;
using SyncfusionExamples.Shared;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace SyncfusionExamples.Server.Controllers
{
    public class OrdersController : ODataController
    {
        protected readonly AppDbContext _dbContext;
        protected readonly DbSet<Order> _dbSet;

        public OrdersController(AppDbContext context)
        {
            _dbContext = context;
            _dbSet = _dbContext.Set<Order>();

            var testOrder = _dbSet.Find((long)1);
            if (testOrder == null)
            {
                _dbSet.Add(new Order { Name = "One", OrderId = 1, OrderStatusId = 2, CustomerName = "ALFKI" });
                _dbSet.Add(new Order { Name = "Two", OrderId = 2, OrderStatusId = 3, CustomerName = "VINET" });
                _dbSet.Add(new Order { Name = "Three", OrderId = 3, OrderStatusId = 4, CustomerName = "TOMSP" });
                _dbSet.Add(new Order { Name = "Four", OrderId = 4, OrderStatusId = 4, CustomerName = "BERGS" });
                _dbSet.Add(new Order { Name = "Five",  OrderId = 5, OrderStatusId = 2, CustomerName = "ALFKI" });
            }

            _dbContext.SaveChanges();
        }

        async Task<bool> RecordExists(long key)
        {
            return await _dbSet.AnyAsync(p => p.OrderId == key);
        }

        [HttpGet]
        [EnableQuery(AllowedQueryOptions = AllowedQueryOptions.All, MaxExpansionDepth = 0)]
        public IQueryable<Order> Get()
        {
            var all = _dbSet.ToList();
            return _dbSet;
        }


        [EnableQuery]
        public SingleResult<Order> Get([FromODataUri] long key)
        {
            IQueryable<Order> result = _dbSet.Where(p => p.OrderId == key);
            return SingleResult.Create(result);
        }

        public async Task<IActionResult> Post([FromBody] Order item)
        {
            if (!ModelState.IsValid)
            {
                return BadRequest(ModelState);
            }

            _dbSet.Add(item);
            await _dbContext.SaveChangesAsync();
            return new CreatedODataResult<Order>(item);
        }

        public async Task<IActionResult> Patch([FromODataUri] long key, Delta<Order> item)
        {
            if (!ModelState.IsValid)
            {
                return BadRequest(ModelState);
            }
            var entity = await _dbSet.FindAsync(key);
            if (entity == null)
            {
                return NotFound();
            }

            //var newDelta = new Delta<Order>();
            //foreach (var fieldName in item.GetChangedPropertyNames())
            //{
            //    if (fieldName != "OrderStatuses")
            //    {
            //        if (item.TryGetPropertyValue(fieldName, out object fieldValue))
            //        {
            //            newDelta.TrySetPropertyValue(fieldName, fieldValue);                    
            //        }
            //    }
            //}

            //var originalUpdates = item.GetChangedPropertyNames();
            //var newDeltaUpdates = newDelta.GetChangedPropertyNames().ToList();                 
            //newDelta.Patch(entity);

            item.Patch(entity);
            
            try
            {
                await _dbContext.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                var exists = await RecordExists(key);
                if (!exists)
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }
            return new UpdatedODataResult<Order>(entity);
        }
        public async Task<IActionResult> Put([FromODataUri] long key, Order item)
        {
            if (!ModelState.IsValid)
            {
                return BadRequest(ModelState);
            }
            if (key != item.OrderId)
            {
                return BadRequest();
            }
            _dbContext.Entry(item).State = EntityState.Modified;
            try
            {
                await _dbContext.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                var exists = await RecordExists(key);
                if (!exists)
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }
            return new UpdatedODataResult<Order>(item);
        }

        public async Task<IActionResult> Delete([FromODataUri] long key)
        {
            var item = _dbSet.FindAsync(key);

            if (item.Result != null)
                _dbSet.Remove(item.Result);
            else
                return NotFound();

            await _dbContext.SaveChangesAsync();

            return NoContent();
        }
    }
}