﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace TestPdfViewer
{
    public class MainPageViewModel : INotifyPropertyChanged
    {
        private Stream? m_pdfDocumentStream;

        /// <summary>
        /// An event to detect the change in the value of a property.
        /// </summary>
        public event PropertyChangedEventHandler? PropertyChanged;

        /// <summary>
        /// The PDF document stream that is loaded into the instance of the PDF viewer. 
        /// </summary>
        public Stream PdfDocumentStream
        {
            get
            {
                return m_pdfDocumentStream;
            }
            set
            {
                m_pdfDocumentStream = value;
                OnPropertyChanged("PdfDocumentStream");
            }
        }

        /// <summary>
        /// Constructor of the view model class
        /// </summary>
        public MainPageViewModel()
        {
            //Accessing the PDF document that is added as embedded resource as stream.
            var stream = typeof(App).GetTypeInfo().Assembly.GetManifestResourceStream("TestPdfViewer.Assets.TEST_PDF.pdf");

            var bytes = new byte[stream.Length];
            stream.Read(bytes, 0, (int)stream.Length);
            m_pdfDocumentStream = new MemoryStream(bytes);
            //m_pdfDocumentStream = typeof(App).GetTypeInfo().Assembly.GetManifestResourceStream("TestPdfViewer.Assets.TEST_PDF.pdf");
        }

        public void OnPropertyChanged(string name)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(name));
        }
    }
}
