// Javascript interop file
window.renderMapItaly = function (element, storesData) {    
    var maps = new ej.maps.Maps({           
        height: '800px',
        width: '100%',
        tooltipDisplayMode: 'Click',
        zoomSettings: {
            enable: true,
            maxZoom: 19,
            zoomOnClick: false,
            doubleClickZoom:true,
            shouldZoomInitially: true,
            toolBars: ["Zoom", "ZoomIn", "ZoomOut", "Pan", "Reset"]
        },
        layers: [
            {                
                urlTemplate: 'https://tile.openstreetmap.org/level/tileX/tileY.png',
                animationDuration: 300,
            },
            {
                type: 'SubLayer',                
                shapeData: italyShape,
                shapeSettings: {
                    fill: 'transparent',
                    border: {
                        color: 'black',
                        width: 1
                    }
                },
                animationDuration: 300,
                markerClusterSettings: {
                    allowClustering: true,
                    allowClusterExpand: true,
                    shape: 'Circle',
                    height: 30,
                    width: 30,
                    labelStyle: { color: 'white' },
                },
                markerSettings: [
                    {
                        visible: true,
                        tooltipSettings: {
                            template: '#template',
                            visible: true,
                            valuePath: 'name',
                            textStyle: { fontFamily: 'Segeo UI' }
                        },
                        shape: 'Image',
                        imageUrlValuePath: 'urlPinImage',
                        height: 23,
                        width: 29,
                        dataSource: storesData
                    }
                ]
            },

        ]
    });

    if (!!storesData) {
        maps.layers[1].markerSettings[0].dataSource = storesData
    }

    
    element.innerHTML = ""
    maps.appendTo(element);
    
};

window.refreshMapItaly = function (element, storesData) {
    element.ej2_instances[0].layers[1].markerSettings[0].dataSource = storesData    
    element.ej2_instances[0].refresh();
};

window.removeCurrentTooltip = function () {    
    let element = document.getElementById('elementOne_mapsTooltip');
    if (!!element) {
        element.remove();
    }        
}