﻿using Microsoft.AspNetCore.Components;
using Microsoft.JSInterop;
using System;
using System.Threading.Tasks;

namespace TestPinMap.Services
{
    public class JsServiceItalyMap
    {
        public const string RenderMapItalyName = "renderMapItaly";
        public const string RefresMapItalyName = "refreshMapItaly";
        public const string RemoveCurrentTooltipName = "removeCurrentTooltip";

        private readonly IJSRuntime jsRuntime;
        public JsServiceItalyMap(IJSRuntime jsRuntime)
        {
            this.jsRuntime = jsRuntime;
        }


        // P u b l i c
        public IJSRuntime GetRuntime()
        {
            return jsRuntime;
        }

        public async Task RenderMapItaly(ElementReference mapsElement,object data)
        {
            try
            {
                await jsRuntime.InvokeVoidAsync(RenderMapItalyName, mapsElement,data);
            }
            catch (Exception ex)
            {

            }
        }

        public async Task RefresMapItaly(ElementReference mapsElement, object data)
        {            

            try
            {
                await jsRuntime.InvokeVoidAsync(RefresMapItalyName, mapsElement, data);
            }
            catch (Exception ex)
            {

            }
        }

        public async Task RemoveCurrentTooltip()
        {
            
            try
            {
                await jsRuntime.InvokeVoidAsync(RemoveCurrentTooltipName);
            }
            catch (Exception ex)
            {

            }
        }


    }
}
