import { AppService } from './services/app.service';
import { Component, Inject, OnDestroy, OnInit } from '@angular/core';
import { Subject, filter, takeUntil } from 'rxjs';
import { loadCldr, L10n, setCulture } from '@syncfusion/ej2-base';

declare var require: any;

loadCldr(
  require('cldr-data/supplemental/numberingSystems.json'),
  require('cldr-data/main/sr/ca-gregorian.json'),
  require('cldr-data/main/sr/numbers.json'),
  require('cldr-data/main/sr/timeZoneNames.json'),
  require('cldr-data/main/sr/currencies.json'),
  require('cldr-data/main/bg/ca-gregorian.json'),
  require('cldr-data/main/bg/numbers.json'),
  require('cldr-data/main/bg/timeZoneNames.json'),
  require('cldr-data/main/bg/currencies.json'),
  require('cldr-data/main/hr/ca-gregorian.json'),
  require('cldr-data/main/hr/numbers.json'),
  require('cldr-data/main/hr/timeZoneNames.json'),
  require('cldr-data/main/hr/currencies.json'),
  require('cldr-data/main/mk/ca-gregorian.json'),
  require('cldr-data/main/mk/numbers.json'),
  require('cldr-data/main/mk/timeZoneNames.json'),
  require('cldr-data/main/mk/currencies.json'),
  require('cldr-data/main/nb/ca-gregorian.json'),
  require('cldr-data/main/nb/numbers.json'),
  require('cldr-data/main/nb/timeZoneNames.json'),
  require('cldr-data/main/nb/currencies.json'),
  require('cldr-data/main/da/ca-gregorian.json'),
  require('cldr-data/main/da/numbers.json'),
  require('cldr-data/main/da/timeZoneNames.json'),
  require('cldr-data/main/da/currencies.json'),
  require('cldr-data/main/sv/ca-gregorian.json'),
  require('cldr-data/main/sv/numbers.json'),
  require('cldr-data/main/sv/timeZoneNames.json'),
  require('cldr-data/main/sv/currencies.json'),
  require('cldr-data/supplemental/weekdata.json')
);

L10n.load({
  'sr': {
    'daterangepicker': {
        placeholder: 'Изаберите област',
        today:"данас",
        startLabel: 
        'Изаберите датум почетка',
        endLabel: 'Изаберите датум завршетка',
        applyText: 'Применити',
        cancelText: 'Поништити, отказати',
        selectedDays: 'Изабрани дани',
        days: 
        'узми',
        customRange: 'прилагођена област'
    },
    'bg': {
      'daterangepicker': {
          placeholder: 'Изберете област',
          today:"днес",
          startLabel: 
          'Изберете начална дата',
          endLabel: 'Изберете крайна дата',
          applyText: 'Приложи',
          cancelText: 'Отмени, отмени',
          selectedDays: 'Избрани дни',
          days: 
          'Вземи го',
          customRange: 'персонализирана зона'
      }
      },
      'hr': {
        'daterangepicker': {
            placeholder: 'Odaberite područje',
            today:"danas",
            startLabel: 
            'Odaberite datum početka',
            endLabel: 'Odaberite datum završetka',
            applyText: 'primijeniti',
            cancelText: 'Otkaži, odustani',
            selectedDays: 'Odabrani dani',
            days: 
            'uzmi',
            customRange: 'prilagođeno područje'
        }
        },
        'mk': {
          'daterangepicker': {
              placeholder: 'Изберете област',
              today:"денес",
              startLabel: 
              'Изберете датум за почеток',
              endLabel: 'Изберете датум на завршување',
              applyText: 'се применуваат',
              cancelText: 'Откажете, откажете се',
              selectedDays: 'Избрани денови',
              days: 
              'Земи го',
              customRange: 'прилагодена област'
          }
          },
          'nb': {
            'daterangepicker': {
                placeholder: 'Velg et område',
                today:"i dag",
                startLabel: 
                'Velg en startdato',
                endLabel: 'Velg en sluttdato',
                applyText: 'brukes',
                cancelText: 'Gi det opp, gi det opp',
                selectedDays: 'Utvalgte dager',
                days: 
                'Ta det',
                customRange: 'tilpasset område'
            }
            },
            'sv': {
              'daterangepicker': {
                  placeholder: 'Välj ett område',
                  today:"I dag",
                  startLabel: 
                  'Välj ett startdatum',
                  endLabel: 'Välj ett slutdatum',
                  applyText: 'är använd',
                  cancelText: 'Ge upp, ge upp',
                  selectedDays: 'Utvalda dagar',
                  days: 
                  'Ta det',
                  customRange: 'anpassat område'
              }
              }
            }
});

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss'],
})
export class AppComponent {
  title = 'cal-error';
  public locale: any = 'en-US';
public clickSerbia() {
  this.locale = 'sr';
}
public clickBulgaria() {
  this.locale = 'bg';
}
public clickCroatia() {
  this.locale = 'hr';
}
public clickMacedonia() {
  this.locale = 'mk';
}
public clickNorway() {
  this.locale = 'nb';
}
public clickDenmark() {
  this.locale = 'da';
}
public clickSweden() {
  this.locale = 'sv';
}
  constructor(private _appService: AppService) {
   
  }
 
}
