﻿using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;
using SchedulerBase.Models;
using System.Diagnostics;
using Newtonsoft.Json;

namespace SchedulerBase.Controllers
{
    public class HomeController : Controller
    {
        private readonly ILogger<HomeController> _logger;

        
        const string blocksJson = @"
                                [
                                    {
                                        ""blockName"": ""GMC"",
                                        ""ob_Id"": ""3CCE9EBC-E6F2-42A6-A401-40363470047E"",
                                        ""blockId"": 1,
                                        ""blockColor"": """",
                                        ""blockGroupId"": 1,
                                        ""startHour"": ""00:00"",
                                        ""endHour"": ""23:59"",
                                        ""isChecked"": true
                                    },
                                    {
                                        ""blockName"": ""CIC_BO.P4"",
                                        ""ob_Id"": ""03114ca7-0b32-4525-93b0-43b1032673cb"",
                                        ""blockId"": 2,
                                        ""blockColor"": """",
                                        ""blockGroupId"": 2,
                                        ""startHour"": ""00:00"",
                                        ""endHour"": ""23:59"",
                                        ""isChecked"": true
                                    },
                                    {
                                        ""blockName"": ""ENDO"",
                                        ""ob_Id"": ""4e3d2632-cadd-4d93-b789-1fc557ee85f2"",
                                        ""blockId"": 3,
                                        ""blockColor"": """",
                                        ""blockGroupId"": 3,
                                        ""startHour"": ""00:00"",
                                        ""endHour"": ""23:59"",
                                        ""isChecked"": true
                                    },
                                    {
                                        ""blockName"": ""BOP.1O"",
                                        ""ob_Id"": ""71fd0154-41d3-49cf-8d38-882e1d1d97c4"",
                                        ""blockId"": 4,
                                        ""blockColor"": """",
                                        ""blockGroupId"": 4,
                                        ""startHour"": ""00:00"",
                                        ""endHour"": ""23:59"",
                                        ""isChecked"": true
                                    },
                                    {
                                        ""blockName"": ""SPEC"",
                                        ""ob_Id"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A0"",
                                        ""blockId"": 5,
                                        ""blockColor"": """",
                                        ""blockGroupId"": 5,
                                        ""startHour"": ""00:00"",
                                        ""endHour"": ""23:59"",
                                        ""isChecked"": true
                                    },
                                    {
                                        ""blockName"": ""OCU"",
                                        ""ob_Id"": ""786fcf3f-e28f-4238-b1c1-33f0b45cad75"",
                                        ""blockId"": 6,
                                        ""blockColor"": """",
                                        ""blockGroupId"": 6,
                                        ""startHour"": ""00:00"",
                                        ""endHour"": ""23:59"",
                                        ""isChecked"": true
                                    },
                                    {
                                        ""blockName"": ""BOP.7D"",
                                        ""ob_Id"": ""9a206298-4b47-47a6-91a3-37d811c6e5bf"",
                                        ""blockId"": 7,
                                        ""blockColor"": """",
                                        ""blockGroupId"": 7,
                                        ""startHour"": ""00:00"",
                                        ""endHour"": ""23:59"",
                                        ""isChecked"": true
                                    },
                                    {
                                        ""blockName"": ""CUORE"",
                                        ""ob_Id"": ""534002E1-E50C-46F5-B1CF-9B1259848C8E"",
                                        ""blockId"": 8,
                                        ""blockColor"": """",
                                        ""blockGroupId"": 8,
                                        ""startHour"": ""00:00"",
                                        ""endHour"": ""23:59"",
                                        ""isChecked"": true
                                    },
                                    {
                                        ""blockName"": ""GEN"",
                                        ""ob_Id"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
                                        ""blockId"": 9,
                                        ""blockColor"": """",
                                        ""blockGroupId"": 9,
                                        ""startHour"": ""00:00"",
                                        ""endHour"": ""23:59"",
                                        ""isChecked"": true
                                    }
                                ]";

        const string roomsJson = @"
                                [
    {
        ""roomName"": ""4C.1"",
        ""fakeRoomName"": null,
        ""roomId"": 18,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 2,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""5e9175e7-9c16-4395-84c0-b552ffd2715d"",
        ""or_ob_ID"": ""03114ca7-0b32-4525-93b0-43b1032673cb"",
        ""or_Name"": ""4C.1"",
        ""or_Description"": ""4C.1"",
        ""or_ShortName"": ""4C.1"",
        ""or_ExternalKey"": ""IU11A09LRY84"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 328,
        ""or_Index"": 1,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2022-11-03T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""4C.2"",
        ""fakeRoomName"": null,
        ""roomId"": 7,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 2,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""37e7b587-69d2-4eb2-b185-c768b248a3f5"",
        ""or_ob_ID"": ""03114ca7-0b32-4525-93b0-43b1032673cb"",
        ""or_Name"": ""4C.2"",
        ""or_Description"": ""4C.2"",
        ""or_ShortName"": ""4C.2"",
        ""or_ExternalKey"": ""IU11A09LU5MW"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 329,
        ""or_Index"": 2,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2022-11-03T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""4C.3"",
        ""fakeRoomName"": null,
        ""roomId"": 2,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 2,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""098aaaed-86fc-4d70-a941-4eefbc2aae7c"",
        ""or_ob_ID"": ""03114ca7-0b32-4525-93b0-43b1032673cb"",
        ""or_Name"": ""4C.3"",
        ""or_Description"": ""4C.3"",
        ""or_ShortName"": ""4C.3"",
        ""or_ExternalKey"": ""IU11A09LV6B1"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 330,
        ""or_Index"": 3,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2022-11-03T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""GMC1"",
        ""fakeRoomName"": ""SN_292C58"",
        ""roomId"": 1,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 1,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""08156100-256d-4bb9-aab2-947557c89708"",
        ""or_ob_ID"": ""3CCE9EBC-E6F2-42A6-A401-40363470047E"",
        ""or_Name"": ""GMC-S1"",
        ""or_Description"": ""GMC - Sala 1"",
        ""or_ShortName"": ""GMC1"",
        ""or_ExternalKey"": ""IU115U3SEQKS"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 228,
        ""or_Index"": 1,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2015-05-18T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""GMC2"",
        ""fakeRoomName"": ""SN_5E0DD1"",
        ""roomId"": 3,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 1,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""16bcefb2-3601-4dec-93dc-4dc787b162ee"",
        ""or_ob_ID"": ""3CCE9EBC-E6F2-42A6-A401-40363470047E"",
        ""or_Name"": ""GMC-S2"",
        ""or_Description"": ""GMC - Sala 2"",
        ""or_ShortName"": ""GMC2"",
        ""or_ExternalKey"": ""IU115U3SGPE4"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 229,
        ""or_Index"": 2,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2015-05-18T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""GMC3"",
        ""fakeRoomName"": ""SN_ED51FA"",
        ""roomId"": 8,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 1,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""4785c664-54a5-408f-8ea1-f38d6e885465"",
        ""or_ob_ID"": ""3CCE9EBC-E6F2-42A6-A401-40363470047E"",
        ""or_Name"": ""GMC-S3"",
        ""or_Description"": ""GMC - Sala 3"",
        ""or_ShortName"": ""GMC3"",
        ""or_ExternalKey"": ""IU115U3SIYNA"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 230,
        ""or_Index"": 3,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2015-05-18T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""GMC4"",
        ""fakeRoomName"": ""SN_6284B6"",
        ""roomId"": 42,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 1,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""e1ea3809-f4ac-4793-ad9e-47e066403096"",
        ""or_ob_ID"": ""3CCE9EBC-E6F2-42A6-A401-40363470047E"",
        ""or_Name"": ""GMC-S4"",
        ""or_Description"": ""GMC - Sala 4"",
        ""or_ShortName"": ""GMC4"",
        ""or_ExternalKey"": ""IU115U3SKOK6"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 231,
        ""or_Index"": 4,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2015-05-18T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""E.A"",
        ""fakeRoomName"": ""SN_7B7DD5"",
        ""roomId"": 26,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 3,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""b1c00540-612a-4f2f-b29e-618d2727b317"",
        ""or_ob_ID"": ""4e3d2632-cadd-4d93-b789-1fc557ee85f2"",
        ""or_Name"": ""END.A"",
        ""or_Description"": ""END.SALA.A"",
        ""or_ShortName"": ""E.A"",
        ""or_ExternalKey"": ""IU1176XD03ET"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 233,
        ""or_Index"": 1,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2017-06-14T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""E.B"",
        ""fakeRoomName"": ""SN_39DCD3"",
        ""roomId"": 4,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 3,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""1d35cee7-2f8a-4c7e-b8f3-8111e6d67eb3"",
        ""or_ob_ID"": ""4e3d2632-cadd-4d93-b789-1fc557ee85f2"",
        ""or_Name"": ""END.B"",
        ""or_Description"": ""END.SALA.B"",
        ""or_ShortName"": ""E.B"",
        ""or_ExternalKey"": ""IU1176XD36I5"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 234,
        ""or_Index"": 2,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2017-06-14T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""E.C"",
        ""fakeRoomName"": ""SN_78BFF8"",
        ""roomId"": 20,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 3,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""6a369ab6-7682-40bc-89a1-bd911aada9af"",
        ""or_ob_ID"": ""4e3d2632-cadd-4d93-b789-1fc557ee85f2"",
        ""or_Name"": ""END.C"",
        ""or_Description"": ""END.SALA.C"",
        ""or_ShortName"": ""E.C"",
        ""or_ExternalKey"": ""IU1176XD4K4F"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 235,
        ""or_Index"": 3,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2017-06-14T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""E.D"",
        ""fakeRoomName"": ""SN_A165AE"",
        ""roomId"": 27,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 3,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""b5e041e2-60b5-4239-ae31-01de3d53ae71"",
        ""or_ob_ID"": ""4e3d2632-cadd-4d93-b789-1fc557ee85f2"",
        ""or_Name"": ""END.D"",
        ""or_Description"": ""END.SALA.D"",
        ""or_ShortName"": ""E.D"",
        ""or_ExternalKey"": ""IU1176XD5SE2"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 238,
        ""or_Index"": 4,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2017-06-14T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""E.E"",
        ""fakeRoomName"": ""SN_202CF5"",
        ""roomId"": 5,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 3,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""239b9967-0377-4dd9-8eca-ab8180c7b9fb"",
        ""or_ob_ID"": ""4e3d2632-cadd-4d93-b789-1fc557ee85f2"",
        ""or_Name"": ""END.E"",
        ""or_Description"": ""END.SALA.E"",
        ""or_ShortName"": ""E.E"",
        ""or_ExternalKey"": ""IU1176XD7I99"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 236,
        ""or_Index"": 5,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2017-06-14T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""E.G"",
        ""fakeRoomName"": ""SN_E25EA9"",
        ""roomId"": 24,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 3,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""a57c6a74-5121-4193-9696-5886bae89442"",
        ""or_ob_ID"": ""4e3d2632-cadd-4d93-b789-1fc557ee85f2"",
        ""or_Name"": ""END.G"",
        ""or_Description"": ""END.SALA.G"",
        ""or_ShortName"": ""E.G"",
        ""or_ExternalKey"": ""IU11798J4RL4"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 240,
        ""or_Index"": 7,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2017-07-28T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""EMO1"",
        ""fakeRoomName"": ""SN_F83411"",
        ""roomId"": 44,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 8,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""F8341187-535B-46A9-888C-76EBB6538767"",
        ""or_ob_ID"": ""534002E1-E50C-46F5-B1CF-9B1259848C8E"",
        ""or_Name"": ""EMO1"",
        ""or_Description"": ""Sala emodinamica con Angiografo Philips"",
        ""or_ShortName"": ""EMO1"",
        ""or_ExternalKey"": ""EMOPHI"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 251,
        ""or_Index"": 1,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2019-11-20T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""EMO2"",
        ""fakeRoomName"": ""SN_865342"",
        ""roomId"": 23,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 8,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""865342F7-1816-42FD-8721-59A1DB4CB73E"",
        ""or_ob_ID"": ""534002E1-E50C-46F5-B1CF-9B1259848C8E"",
        ""or_Name"": ""EMO2"",
        ""or_Description"": ""Sala emodinamica con Angiografo GE"",
        ""or_ShortName"": ""EMO2"",
        ""or_ExternalKey"": ""EMOGE"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 250,
        ""or_Index"": 2,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2019-11-20T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""EP"",
        ""fakeRoomName"": ""SN_E0B7A7"",
        ""roomId"": 41,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 8,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""e0b7a7d7-f882-4c47-87a3-ddb9a40fcbf6"",
        ""or_ob_ID"": ""534002E1-E50C-46F5-B1CF-9B1259848C8E"",
        ""or_Name"": ""EP"",
        ""or_Description"": ""ElettroFisiologia"",
        ""or_ShortName"": ""EP"",
        ""or_ExternalKey"": ""23949-ARITMO"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 252,
        ""or_Index"": 3,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2019-11-27T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""AP.1"",
        ""fakeRoomName"": ""SN_31B74F"",
        ""roomId"": 6,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 4,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""31b74f74-60d0-4852-a45a-2e1004baf5f1"",
        ""or_ob_ID"": ""71fd0154-41d3-49cf-8d38-882e1d1d97c4"",
        ""or_Name"": ""SALA AP.1"",
        ""or_Description"": ""SALA AP.1"",
        ""or_ShortName"": ""AP.1"",
        ""or_ExternalKey"": ""IU118VJ1T5P4"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""http://10.154.19.21/axis-cgi/mjpg/video.cgi?resolution=320x240&compression=80"",
        ""or_IDBed"": 288,
        ""or_Index"": 1,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2020-09-21T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""AP.3"",
        ""fakeRoomName"": ""SN_67C9A9"",
        ""roomId"": 19,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 4,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""67c9a997-1a60-48f6-ba4b-61cc074d65ed"",
        ""or_ob_ID"": ""71fd0154-41d3-49cf-8d38-882e1d1d97c4"",
        ""or_Name"": ""SALA AP.3"",
        ""or_Description"": ""SALA AP.3"",
        ""or_ShortName"": ""AP.3"",
        ""or_ExternalKey"": ""IU118VJ1WMO5"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""http://10.154.20.21/axis-cgi/mjpg/video.cgi?resolution=320x240&compression=80"",
        ""or_IDBed"": 290,
        ""or_Index"": 3,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2020-09-21T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""O.01"",
        ""fakeRoomName"": ""SN_6181F1"",
        ""roomId"": 25,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 6,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""a8097d1f-1704-492f-8443-16fdd71f7f25"",
        ""or_ob_ID"": ""786fcf3f-e28f-4238-b1c1-33f0b45cad75"",
        ""or_Name"": ""Sala 01"",
        ""or_Description"": ""Blocco Operatorio Day Surgery Oculistica Sala 01 "",
        ""or_ShortName"": ""O.01"",
        ""or_ExternalKey"": ""IU1130M4L2GT"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.151.4.26"",
        ""or_IDBed"": 218,
        ""or_Index"": 1,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""O.02"",
        ""fakeRoomName"": ""SN_B3824D"",
        ""roomId"": 21,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 6,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""7679e0f7-3b42-4250-b33a-f7c753ccee8b"",
        ""or_ob_ID"": ""786fcf3f-e28f-4238-b1c1-33f0b45cad75"",
        ""or_Name"": ""Sala 02"",
        ""or_Description"": ""Blocco Operatorio Day Surgery Oculistica Sala 2"",
        ""or_ShortName"": ""O.02"",
        ""or_ExternalKey"": ""IU1130M4NH05"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.151.4.27"",
        ""or_IDBed"": 219,
        ""or_Index"": 2,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""O.03"",
        ""fakeRoomName"": ""SN_6355D8"",
        ""roomId"": 40,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 6,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""cbb2de18-f17f-401f-b0b6-9d4f11fadbcb"",
        ""or_ob_ID"": ""786fcf3f-e28f-4238-b1c1-33f0b45cad75"",
        ""or_Name"": ""Sala 03"",
        ""or_Description"": ""Blocco Operatorio Day Surgery Oculistica Sala 3"",
        ""or_ShortName"": ""O.03"",
        ""or_ExternalKey"": ""IU118AYBV6K0"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": null,
        ""or_IDBed"": 249,
        ""or_Index"": 3,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2019-07-25T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""H.01"",
        ""fakeRoomName"": ""SN_F6ADA5"",
        ""roomId"": 43,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 7,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""f6ada5f9-08dc-429e-90cc-bcbd741f04ef"",
        ""or_ob_ID"": ""9a206298-4b47-47a6-91a3-37d811c6e5bf"",
        ""or_Name"": ""H.01"",
        ""or_Description"": ""H.01"",
        ""or_ShortName"": ""H.01"",
        ""or_ExternalKey"": ""IU118ZJIHMOF"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""http://10.151.43.27/axis-cgi/mjpg/video.cgi?resolution=320x240&compression=80"",
        ""or_IDBed"": 298,
        ""or_Index"": 1,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2020-11-23T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""H.02"",
        ""fakeRoomName"": ""SN_789D8C"",
        ""roomId"": 22,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 7,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""789d8ca7-c53b-47a1-8eb4-dbbde7d51d30"",
        ""or_ob_ID"": ""9a206298-4b47-47a6-91a3-37d811c6e5bf"",
        ""or_Name"": ""H.02"",
        ""or_Description"": ""H.02"",
        ""or_ShortName"": ""H.02"",
        ""or_ExternalKey"": ""IU118ZJIIOIX"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""http://10.151.43.28/axis-cgi/mjpg/video.cgi?resolution=320x240&compression=80"",
        ""or_IDBed"": 299,
        ""or_Index"": 2,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""2020-11-23T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""S.01"",
        ""fakeRoomName"": ""SN_E05445"",
        ""roomId"": 9,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 5,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""5DEC13AA-71DD-4dc1-982C-FBD42E952650"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A0"",
        ""or_Name"": ""Sala 01"",
        ""or_Description"": ""Blocco Operatorio 2°J Sala 01"",
        ""or_ShortName"": ""S.01"",
        ""or_ExternalKey"": ""REP__00000LN"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.152.0.29"",
        ""or_IDBed"": 174,
        ""or_Index"": 1,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""S.02"",
        ""fakeRoomName"": ""SN_61897C"",
        ""roomId"": 10,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 5,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""5DEC13AA-71DD-4dc1-982C-FBD42E952651"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A0"",
        ""or_Name"": ""Sala 02"",
        ""or_Description"": ""Blocco Operatorio 2°J Sala 02"",
        ""or_ShortName"": ""S.02"",
        ""or_ExternalKey"": ""REP__00000LO"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.152.0.28"",
        ""or_IDBed"": 175,
        ""or_Index"": 2,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""S.03"",
        ""fakeRoomName"": ""SN_BA689A"",
        ""roomId"": 11,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 5,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""5DEC13AA-71DD-4dc1-982C-FBD42E952652"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A0"",
        ""or_Name"": ""Sala 03"",
        ""or_Description"": ""Blocco Operatorio 2°J Sala 03"",
        ""or_ShortName"": ""S.03"",
        ""or_ExternalKey"": ""REP__00000LP"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.152.0.27"",
        ""or_IDBed"": 176,
        ""or_Index"": 3,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""S.04"",
        ""fakeRoomName"": ""SN_97323B"",
        ""roomId"": 12,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 5,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""5DEC13AA-71DD-4dc1-982C-FBD42E952653"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A0"",
        ""or_Name"": ""Sala 04"",
        ""or_Description"": ""Blocco Operatorio 2°J Sala 04"",
        ""or_ShortName"": ""S.04"",
        ""or_ExternalKey"": ""REP__00000LQ"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.152.0.20"",
        ""or_IDBed"": 177,
        ""or_Index"": 4,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""S.05"",
        ""fakeRoomName"": ""SN_FC76AA"",
        ""roomId"": 13,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 5,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""5DEC13AA-71DD-4dc1-982C-FBD42E952654"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A0"",
        ""or_Name"": ""Sala 05"",
        ""or_Description"": ""Blocco Operatorio 2°J Sala 05"",
        ""or_ShortName"": ""S.05"",
        ""or_ExternalKey"": ""REP__00000LR"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.152.0.25"",
        ""or_IDBed"": 178,
        ""or_Index"": 5,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""S.06"",
        ""fakeRoomName"": ""SN_9481D3"",
        ""roomId"": 14,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 5,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""5DEC13AA-71DD-4dc1-982C-FBD42E952655"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A0"",
        ""or_Name"": ""Sala 06"",
        ""or_Description"": ""Blocco Operatorio 2°J Sala 06"",
        ""or_ShortName"": ""S.06"",
        ""or_ExternalKey"": ""REP__00000LS"",
        ""or_Specifications"": ""RX"",
        ""or_WebcamIP"": ""10.152.0.26"",
        ""or_IDBed"": 179,
        ""or_Index"": 6,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""S.07"",
        ""fakeRoomName"": ""SN_DCD5ED"",
        ""roomId"": 15,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 5,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""5DEC13AA-71DD-4dc1-982C-FBD42E952656"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A0"",
        ""or_Name"": ""Sala 07"",
        ""or_Description"": ""Blocco Operatorio 2°J Sala 07"",
        ""or_ShortName"": ""S.07"",
        ""or_ExternalKey"": ""REP__00000LT"",
        ""or_Specifications"": ""RX"",
        ""or_WebcamIP"": ""10.152.0.19"",
        ""or_IDBed"": 180,
        ""or_Index"": 7,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""S.08"",
        ""fakeRoomName"": ""SN_803BCA"",
        ""roomId"": 16,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 5,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""5DEC13AA-71DD-4dc1-982C-FBD42E952657"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A0"",
        ""or_Name"": ""Sala 08"",
        ""or_Description"": ""Blocco Operatorio 2°J Sala 08"",
        ""or_ShortName"": ""S.08"",
        ""or_ExternalKey"": ""REP__00000LU"",
        ""or_Specifications"": ""RX"",
        ""or_WebcamIP"": ""10.152.0.24"",
        ""or_IDBed"": 181,
        ""or_Index"": 8,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""S.09"",
        ""fakeRoomName"": ""SN_5D8451"",
        ""roomId"": 17,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 5,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""5DEC13AA-71DD-4dc1-982C-FBD42E952658"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A0"",
        ""or_Name"": ""Sala 09"",
        ""or_Description"": ""Blocco Operatorio 2°J Sala 09"",
        ""or_ShortName"": ""S.09"",
        ""or_ExternalKey"": ""REP__00000LV"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.152.0.23"",
        ""or_IDBed"": 182,
        ""or_Index"": 9,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""G.01"",
        ""fakeRoomName"": ""SN_DC077F"",
        ""roomId"": 28,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 9,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""C11213FD-059D-4640-BC94-24EA4853B6E0"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
        ""or_Name"": ""Sala 01"",
        ""or_Description"": ""Blocco Operatorio 1°J Sala 01"",
        ""or_ShortName"": ""G.01"",
        ""or_ExternalKey"": ""REP__00000LB"",
        ""or_Specifications"": ""RX;OBESI;VASCOLARE"",
        ""or_WebcamIP"": ""10.154.8.26"",
        ""or_IDBed"": 164,
        ""or_Index"": 1,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""G.02"",
        ""fakeRoomName"": ""SN_4E3913"",
        ""roomId"": 29,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 9,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""C11213FD-059D-4640-BC94-24EA4853B6E1"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
        ""or_Name"": ""Sala 02"",
        ""or_Description"": ""Blocco Operatorio 1°J Sala 02"",
        ""or_ShortName"": ""G.02"",
        ""or_ExternalKey"": ""REP__00000LC"",
        ""or_Specifications"": ""RX;OBESI"",
        ""or_WebcamIP"": ""10.154.8.25"",
        ""or_IDBed"": 165,
        ""or_Index"": 2,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""G.03"",
        ""fakeRoomName"": ""SN_35E71F"",
        ""roomId"": 30,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 9,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""C11213FD-059D-4640-BC94-24EA4853B6E2"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
        ""or_Name"": ""Sala 03"",
        ""or_Description"": ""Blocco Operatorio 1°J Sala 03"",
        ""or_ShortName"": ""G.03"",
        ""or_ExternalKey"": ""REP__00000LD"",
        ""or_Specifications"": ""LPS"",
        ""or_WebcamIP"": ""10.154.8.24"",
        ""or_IDBed"": 166,
        ""or_Index"": 3,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""G.04"",
        ""fakeRoomName"": ""SN_D6D82E"",
        ""roomId"": 31,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 9,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""C11213FD-059D-4640-BC94-24EA4853B6E3"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
        ""or_Name"": ""Sala 04"",
        ""or_Description"": ""Blocco Operatorio 1°J Sala 04"",
        ""or_ShortName"": ""G.04"",
        ""or_ExternalKey"": ""REP__00000LE"",
        ""or_Specifications"": ""LPS;URO;GINEC"",
        ""or_WebcamIP"": ""10.154.8.23"",
        ""or_IDBed"": 167,
        ""or_Index"": 4,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""G.05"",
        ""fakeRoomName"": ""SN_6E89C4"",
        ""roomId"": 32,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 9,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""C11213FD-059D-4640-BC94-24EA4853B6E4"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
        ""or_Name"": ""Sala 05"",
        ""or_Description"": ""Blocco Operatorio 1°J Sala 05"",
        ""or_ShortName"": ""G.05"",
        ""or_ExternalKey"": ""REP__00000LF"",
        ""or_Specifications"": ""LPS"",
        ""or_WebcamIP"": ""10.154.8.22"",
        ""or_IDBed"": 168,
        ""or_Index"": 5,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""G.06"",
        ""fakeRoomName"": ""SN_C35319"",
        ""roomId"": 33,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 9,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""C11213FD-059D-4640-BC94-24EA4853B6E5"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
        ""or_Name"": ""Sala 06"",
        ""or_Description"": ""Blocco Operatorio 1°J Sala 06"",
        ""or_ShortName"": ""G.06"",
        ""or_ExternalKey"": ""REP__00000LM"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.154.8.21"",
        ""or_IDBed"": 169,
        ""or_Index"": 6,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""G.07"",
        ""fakeRoomName"": ""SN_2FD001"",
        ""roomId"": 34,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 9,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""C11213FD-059D-4640-BC94-24EA4853B6E6"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
        ""or_Name"": ""Sala 07"",
        ""or_Description"": ""Blocco Operatorio 1°J Sala 07"",
        ""or_ShortName"": ""G.07"",
        ""or_ExternalKey"": ""REP__00000LG"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.154.8.20"",
        ""or_IDBed"": 170,
        ""or_Index"": 7,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""G.08"",
        ""fakeRoomName"": ""SN_E13832"",
        ""roomId"": 35,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 9,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""C11213FD-059D-4640-BC94-24EA4853B6E7"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
        ""or_Name"": ""Sala 08"",
        ""or_Description"": ""Blocco Operatorio 1°J Sala 08"",
        ""or_ShortName"": ""G.08"",
        ""or_ExternalKey"": ""REP__00000LH"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.154.8.19"",
        ""or_IDBed"": 171,
        ""or_Index"": 8,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""G.09"",
        ""fakeRoomName"": ""SN_026123"",
        ""roomId"": 36,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 9,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""C11213FD-059D-4640-BC94-24EA4853B6E8"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
        ""or_Name"": ""Sala 09"",
        ""or_Description"": ""Blocco Operatorio 1°J Sala 09"",
        ""or_ShortName"": ""G.09"",
        ""or_ExternalKey"": ""REP__00000LI"",
        ""or_Specifications"": ""LPS"",
        ""or_WebcamIP"": ""10.154.8.18"",
        ""or_IDBed"": 172,
        ""or_Index"": 9,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""G.10"",
        ""fakeRoomName"": ""SN_0C95B3"",
        ""roomId"": 37,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 9,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""C11213FD-059D-4640-BC94-24EA4853B6E9"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
        ""or_Name"": ""Sala 10"",
        ""or_Description"": ""Blocco Operatorio 1°J Sala 10"",
        ""or_ShortName"": ""G.10"",
        ""or_ExternalKey"": ""REP__00000LJ"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.154.8.17"",
        ""or_IDBed"": 173,
        ""or_Index"": 10,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""G.11"",
        ""fakeRoomName"": ""SN_BC4933"",
        ""roomId"": 38,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 9,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""C11213FD-059D-4640-BC94-24EA4853B6EA"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
        ""or_Name"": ""Sala 11"",
        ""or_Description"": ""Blocco Operatorio 1°J Sala 11"",
        ""or_ShortName"": ""G.11"",
        ""or_ExternalKey"": ""REP__00000LK"",
        ""or_Specifications"": ""LPS"",
        ""or_WebcamIP"": ""10.154.8.16"",
        ""or_IDBed"": 184,
        ""or_Index"": 11,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    },
    {
        ""roomName"": ""G.12"",
        ""fakeRoomName"": ""SN_3C4A5C"",
        ""roomId"": 39,
        ""roomColor"": ""#8c8c8c"",
        ""roomGroupId"": 9,
        ""startHour"": ""00:00"",
        ""endHour"": ""23:59"",
        ""or_ID"": ""C11213FD-059D-4640-BC94-24EA4853B6EB"",
        ""or_ob_ID"": ""EB669CB7-A44F-4b40-9598-B798CCABD6A1"",
        ""or_Name"": ""Sala 12"",
        ""or_Description"": ""Blocco Operatorio 1°J Sala 12"",
        ""or_ShortName"": ""G.12"",
        ""or_ExternalKey"": ""REP__00000LL"",
        ""or_Specifications"": null,
        ""or_WebcamIP"": ""10.154.8.15"",
        ""or_IDBed"": 185,
        ""or_Index"": 12,
        ""or_SpecialRequests"": null,
        ""or_ValidFrom"": ""1900-01-01T00:00:00"",
        ""or_ValidTo"": null,
        ""or_ReasonForClosing"": null
    }
]";

        public HomeController(ILogger<HomeController> logger)
        {
            _logger = logger;
            blocks = JsonConvert.DeserializeObject<List<Block>>(blocksJson);
            rooms = JsonConvert.DeserializeObject<List<Room>>(roomsJson);
        }
        public List<Block> blocks { get; set; }
        public List<Room> rooms { get; set; }

        public IActionResult Index()
        {
            ViewBag.datasource = GetResourceData();
            // datasource for room resources
            List<RoomResource> rooms = new List<RoomResource>();
            rooms.Add(new RoomResource { RoomText = "ROOM 1", Id = 1, RoomColor = "#cb6bb2", IsExpand = true });
            rooms.Add(new RoomResource { RoomText = "ROOM 2", Id = 2, RoomColor = "#56ca85", IsExpand = true });
            rooms.Add(new RoomResource { RoomText = "ROOM 3", Id = 3, RoomColor = "#56ca85", IsExpand = true });
            rooms.Add(new RoomResource { RoomText = "ROOM 4", Id = 4, RoomColor = "#56ca85", IsExpand = true });
            rooms.Add(new RoomResource { RoomText = "ROOM 5", Id = 5, RoomColor = "#56ca85", IsExpand = true });
            rooms.Add(new RoomResource { RoomText = "ROOM 6", Id = 6, RoomColor = "#56ca85", IsExpand = true });
            rooms.Add(new RoomResource { RoomText = "ROOM 7", Id = 7, RoomColor = "#56ca85", IsExpand = true });
            rooms.Add(new RoomResource { RoomText = "ROOM 8", Id = 8, RoomColor = "#56ca85", IsExpand = true });
            rooms.Add(new RoomResource { RoomText = "ROOM 9", Id = 9, RoomColor = "#56ca85", IsExpand = true });
            rooms.Add(new RoomResource { RoomText = "ROOM 10", Id = 10, RoomColor = "#56ca85", IsExpand = true });
            ViewBag.Rooms = rooms;
            // datasource for owner resources
            List<OwnerResource> owners = new List<OwnerResource>();
            owners.Add(new OwnerResource { OwnerText = "Nancy1", Id = 1, OwnerGroupId = 1, OwnerColor = "#ffaa00" });
            owners.Add(new OwnerResource { OwnerText = "Steven2", Id = 2, OwnerGroupId = 2, OwnerColor = "#f8a398" });
            owners.Add(new OwnerResource { OwnerText = "Michael3", Id = 3, OwnerGroupId = 3, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael4", Id = 4, OwnerGroupId = 4, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael5", Id = 5, OwnerGroupId = 5, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael6", Id = 6, OwnerGroupId = 6, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael7", Id = 7, OwnerGroupId = 7, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael8", Id = 8, OwnerGroupId = 8, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael9", Id = 9, OwnerGroupId = 9, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael10", Id = 10, OwnerGroupId = 10, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael11", Id = 11, OwnerGroupId = 1, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael12", Id = 12, OwnerGroupId = 2, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael13", Id = 13, OwnerGroupId = 3, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael14", Id = 14, OwnerGroupId = 4, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael15", Id = 15, OwnerGroupId = 5, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael16", Id = 16, OwnerGroupId = 6, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael17", Id = 17, OwnerGroupId = 7, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael18", Id = 18, OwnerGroupId = 8, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael19", Id = 19, OwnerGroupId = 9, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael20", Id = 20, OwnerGroupId = 10, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael21", Id = 21, OwnerGroupId = 1, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael22", Id = 22, OwnerGroupId = 2, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael23", Id = 23, OwnerGroupId = 3, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael24", Id = 24, OwnerGroupId = 4, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael25", Id = 25, OwnerGroupId = 5, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael26", Id = 26, OwnerGroupId = 6, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael27", Id = 27, OwnerGroupId = 7, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael28", Id = 28, OwnerGroupId = 8, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael29", Id = 29, OwnerGroupId = 9, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael30", Id = 30, OwnerGroupId = 10, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael31", Id = 31, OwnerGroupId = 1, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael32", Id = 32, OwnerGroupId = 2, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael33", Id = 33, OwnerGroupId = 3, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael34", Id = 34, OwnerGroupId = 4, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael35", Id = 35, OwnerGroupId = 5, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael36", Id = 36, OwnerGroupId = 6, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael37", Id = 37, OwnerGroupId = 7, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael38", Id = 38, OwnerGroupId = 8, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael39", Id = 39, OwnerGroupId = 9, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael40", Id = 40, OwnerGroupId = 10, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael41", Id = 41, OwnerGroupId = 1, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael42", Id = 42, OwnerGroupId = 2, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael43", Id = 43, OwnerGroupId = 3, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael44", Id = 44, OwnerGroupId = 4, OwnerColor = "#7499e1" });
            owners.Add(new OwnerResource { OwnerText = "Michael45", Id = 45, OwnerGroupId = 5, OwnerColor = "#7499e1" });
            ViewBag.Owners = owners;

            ViewBag.Resources = new string[] { "Rooms", "Owners" };
            return View();
        }

        public IActionResult Privacy()
        {
            return View();
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }

        public List<ResourceData> GetResourceData()
        {
            List<ResourceData> resourceData = new List<ResourceData>();
            resourceData.Add(new ResourceData
            {
                Id = 1,
                Subject = "Requirement planning",
                StartTime = new DateTime(2023, 4, 1, 1, 0, 0),
                EndTime = new DateTime(2023, 4, 1, 5, 0, 0),
                IsAllDay = false,
                OwnerId = 1,
                RoomId = 1
            });
            resourceData.Add(new ResourceData
            {
                Id = 2,
                Subject = "Quality Analysis",
                StartTime = new DateTime(2023, 4, 1, 1, 0, 0),
                EndTime = new DateTime(2023, 4, 1, 5, 0, 0),
                IsAllDay = false,
                OwnerId = 3,
                RoomId = 1
            });
            resourceData.Add(new ResourceData
            {
                Id = 3,
                Subject = "Resource planning",
                StartTime = new DateTime(2023, 4, 1, 1, 0, 0),
                EndTime = new DateTime(2023, 4, 1, 5, 0, 0),
                IsAllDay = false,
                OwnerId = 2,
                RoomId = 2
            });
            return resourceData;
        }

    }

    public class ResourceData
    {
        public int Id { get; set; }
        public string Subject { get; set; }
        public DateTime StartTime { get; set; }
        public DateTime EndTime { get; set; }
        public bool IsAllDay { get; set; }
        public int OwnerId { get; set; }
        public int RoomId { get; set; }
    }

    public class RoomResource
    {
        public string RoomText { set; get; }
        public int Id { set; get; }
        public string RoomColor { set; get; }
        public bool IsExpand { get; set; }
    }

    public class OwnerResource
    {
        public string OwnerText { set; get; }
        public int Id { set; get; }
        public string OwnerColor { set; get; }
        public int OwnerGroupId { set; get; }
    }

    public class AppointmentData
    {
        public int Id { get; set; }
        public string Subject { get; set; }
        public DateTime StartTime { get; set; }
        public DateTime EndTime { get; set; }
    }

    public class Block
    {

        public string BlockName { get; set; }
        public Guid Ob_Id { get; set; }
        public long BlockId { get; set; }
        public string BlockColor { get; set; }
        public long BlockGroupId { get; set; }
        public string StartHour { get; set; }
        public string EndHour { get; set; }
        public bool IsChecked { get; set; }
    }

    public class Room
    {
        public string roomName { get; set; }
        public string fakeRoomName { get; set; }
        public int roomId { get; set; }
        public string roomColor { get; set; }
        public int roomGroupId { get; set; }
        public string startHour { get; set; }
        public string endHour { get; set; }
        public string or_ID { get; set; }
        public string or_ob_ID { get; set; }
        public string or_Name { get; set; }
        public string or_Description { get; set; }
        public string or_ShortName { get; set; }
        public string or_ExternalKey { get; set; }
        public string or_Specifications { get; set; }
        public string or_WebcamIP { get; set; }
        public string or_IDBed { get; set; }
        public int or_Index { get; set; }
        public string or_SpecialRequests { get; set; }
        public string or_ValidFrom { get; set; }
        public string or_ValidTo { get; set; }
        public string or_ReasonForClosing { get; set; }
    }
}