﻿namespace Sandpit
{
    interface DataItem
    {
        parentId?: number,
        id: number,
        name: string,
        startDate?: Date,
        endDate?: Date,
        hoursWorked?: number,

        sectionId?: number
    };

    export class Sections_1
    {
        private readonly m_rawData: Array<DataItem> = [
            { id: 0, name: 'Section I' },
            { id: 1, parentId: 0, name: 'Task 1' },
            { id: 2, parentId: 1, name: 'Task 1.1', startDate: new Date( '2023/12/3' ) },
            { id: 3, parentId: 1, name: 'Task 1.2' },
            { id: 4, parentId: 0, name: 'Task 2' },
            { id: 5, parentId: 4, name: 'Task 2.1', hoursWorked: 22.5 },
            { id: 6, parentId: 4, name: 'Task 2.2' },
            { id: 7, name: 'Section II' },
            { id: 8, name: 'Section III' },
            { parentId: 8, id: 9, name: 'Task 1' }, 
            { parentId: 9, id: 10, name: 'Task 1.1' },
            { parentId: 9, id: 11, name: 'Task 1.2' }
        ];

        private m_data: Array<DataItem>;

        private m_treegrid: ej.treegrid.TreeGrid;

        public constructor()
        { 
            this.m_data = JSON.parse( JSON.stringify( this.m_rawData ) );

            // TreeGrid
            this.m_treegrid = new ej.treegrid.TreeGrid( {
                dataSource: this.m_data,
                parentIdMapping: 'parentId',
                idMapping: 'id',
                columns: [
                    { field: 'parentId', visible: false },
                    { field: 'id', isPrimaryKey: true, visible: false },
                    { field: 'name' },
                    { field: 'startDate' },
                    { field: 'endDate' },
                    { field: 'hoursWorked' }
                ],
                treeColumnIndex: 2,
                editSettings: {
                    allowEditing: true,
                    mode: 'Cell'
                },
                locale: 'fr-BE',
                allowRowDragAndDrop: true,
                rowDataBound: ( args: ej.grids.RowDataBoundEventArgs ) => { this._rowDataBound( args ); }
            } );
            this.m_treegrid.appendTo( 'div#treegrid' );
        };

        private _rowDataBound( args: ej.grids.RowDataBoundEventArgs )
        {
            if ( this._isDataItemASection( ( args.data as DataItem ) ) === true )
            {
                console.dir( this.m_treegrid.getColumns() );
                let colSpan: number = 1;
                this.m_treegrid.getColumns().forEach( ( column: ej.treegrid.Column, i: number ) =>
                {
                    if ( i > this.m_treegrid.treeColumnIndex )
                    {
                        ( args.row as any ).cells[i + ( this.m_treegrid.allowRowDragAndDrop ? 1 : 0 )].style.display = 'none';
                        colSpan++;
                    }
                } );
                ( args.row as any ).cells[this.m_treegrid.treeColumnIndex + ( this.m_treegrid.allowRowDragAndDrop ? 1 : 0 )].colSpan = colSpan;
            };
        }

        /**
         * Does the supplied DataItem represent a section?
         * @param { DataItem } dataItem
         */
        private _isDataItemASection( dataItem: DataItem ): boolean
        {
            return ( dataItem.parentId === undefined );
        }
    };
};