namespace PopupDemo;

public partial class PopupContent : ContentView
{
    private const string PdfUrl =
        "https://www.syncfusion.com/downloads/support/directtrac/general/pd/PDF_Succinctly1928776572";

    public PopupContent()
    {
        InitializeComponent();
    }

    private static async Task<Stream> GetPdfDocumentStream(string url)
    {
        var httpClient = new HttpClient();
        var response = await httpClient.GetAsync(url);

        return await response.Content.ReadAsStreamAsync();
    }

    private void MyPopupPdfViewer_OnLoaded(object sender, EventArgs e)
    {
        // Never gets called!
    }

    private async void Button_OnClicked(object sender, EventArgs e)
    {
        var documentStream = await GetPdfDocumentStream(PdfUrl);

        MyPopupPdfViewer.LoadDocument(documentStream); // This does not work, the loading spinner shows but document will never load

        //await MyPopupPdfViewer.LoadDocumentAsync(documentStream); // This does not work either
    }

    private void VisualElement_OnLoaded(object sender, EventArgs e)
    {
        // Never gets called!
    }
}