﻿namespace PopupDemo;

public partial class MainPage : ContentPage
{
    private const string PdfUrl =
        "https://www.syncfusion.com/downloads/support/directtrac/general/pd/PDF_Succinctly1928776572";

    public MainPage()
    {
        InitializeComponent();
        SetPdfDocumentStream(PdfUrl);
    }

    private async void SetPdfDocumentStream(string url)
    {
        var httpClient = new HttpClient();
        var response = await httpClient.GetAsync(url);

        var documentStream = await response.Content.ReadAsStreamAsync();

        MyPdfViewer.DocumentSource = documentStream; // Works as expected
    }

    private void Button_OnClicked(object sender, EventArgs e)
    {
        MyPopup.Show();
    }

    private void MyPdfViewer_OnLoaded(object sender, EventArgs e)
    {
        // Gets called as expected
    }
}