﻿using SfGridRefresh.Library.Models.Filter;
using SfGridRefresh.Library.Services;

namespace SfGridRefresh.Library.State;

public class FilterState : IFilterState
{
    private readonly ILocalStorageService _localStorageService;

    public FilterState(ILocalStorageService localStorageService)
    {
        _localStorageService = localStorageService;
    }

    public async Task<FilterSection> GetInitialState(string sectionTitle)
    {
        if (!string.IsNullOrWhiteSpace(sectionTitle))
        {
            return await _localStorageService.GetItem<FilterSection>($"initial-filterSection-{sectionTitle.Replace(" ", "")}");
        }

        return null!;
    }

    public async Task StoreInitialState(FilterSection filterSection)
    {
        await _localStorageService.SetItem($"initial-filterSection-{filterSection.SectionTitle.Replace(" ", "")}", filterSection);
    }

    public async Task DeleteInitialState(string sectionTitle)
    {
        await _localStorageService.DeleteItem($"initial-filterSection-{sectionTitle.Replace(" ", "")}");
    }

    public async Task<FilterSection> GetCurrentState(string sectionTitle)
    {
        if (!string.IsNullOrWhiteSpace(sectionTitle))
        {
            return await _localStorageService.GetItem<FilterSection>($"current-filterSection-{sectionTitle.Replace(" ", "")}");
        }

        return null!;
    }

    public async Task StoreCurrentState(FilterSection filterSection)
    {
        await _localStorageService.SetItem($"current-filterSection-{filterSection.SectionTitle.Replace(" ", "")}", filterSection);
    }

    public async Task DeleteCurrentState(string sectionTitle)
    {
        if (!string.IsNullOrWhiteSpace(sectionTitle))
        {
            await _localStorageService.DeleteItem($"current-filterSection-{sectionTitle.Replace(" ", "")}");
        }
    }
}
