﻿using Microsoft.JSInterop;
using System.Text.Json;

namespace SfGridRefresh.Library.Services
{
    public class LocalStorageService : ILocalStorageService
    {
        private IJSRuntime JSRuntime { get; }

        public LocalStorageService(IJSRuntime jsRuntime)
        {
            JSRuntime = jsRuntime;
        }

        public async Task<T> GetItem<T>(string key)
        {
            var json = await JSRuntime.InvokeAsync<string>("localStorage.getItem", key);
            if (json is null)
                return default!;

            return JsonSerializer.Deserialize<T>(json)!;
        }

        public async Task SetItem<T>(string key, T value)
        {
            var json = JsonSerializer.Serialize(value);
            await JSRuntime.InvokeVoidAsync("localStorage.setItem", key, json);
        }

        public async Task DeleteItem(string key)
        {
            await JSRuntime.InvokeVoidAsync("localStorage.removeItem", key);
        }
    }
}
