using Microsoft.Extensions.DependencyInjection;
using SfGridRefresh.Library.Services;
using SfGridRefresh.Library.State;
using Syncfusion.Blazor;

namespace SfGridRefresh.Library
{
    public static class ServiceCollectionExtensions
    {
        public static void AddServices(this IServiceCollection services)
        {
            // Version 22.1.39
            Syncfusion.Licensing.SyncfusionLicenseProvider.RegisterLicense("Ngo9BigBOggjHTQxAR8/V1NGaF5cXmpCf1FpRmJGdld5fUVHYVZUTXxaS00DNHVRdkdgWXhcd3VUR2JeUkd/WUo=");
            services.AddSyncfusionBlazor();
            services.AddScoped<RezFilterService>();
            services.AddScoped<ILocalStorageService, LocalStorageService>();
            services.AddScoped<IAppState, AppState>();
        }
    }
}
