﻿namespace SfGridRefresh.Shared.Models;

public class TestTrip
{
    public int TripID { get; set; }
    public int RezID { get; set; }
    public string TripName { get; set; }
    public string Status { get; set; }
    public DateTime TripCreatedDate { get; set; }
    public DateTime StartDate { get; set; }
    public DateTime EndDate { get; set; }
    public string PrimaryDestination { get; set; }
    public Account Account { get; set; }
    public Request? Request { get; set; }
    public Traveler Traveler { get; set; }
    public List<Traveler>? RequestTravelers { get; set; }
    public int? TravelerCount { get; set; }
    public List<string>? HasSegments { get; set; }
    public List<string> Attributes { get; set; }
    public List<string> Destinations { get; set; }
    public TicketingSummary? TicketingSummary { get; set; }
    public DateTime CreatedAt { get; set; }
    public DateTime? ModifiedAt { get; set; }
    public List<PNR> PNRs { get; set; }
    public bool Approved { get; set; }
    public string ContactId { get; set; }
    public string Image { get; set; }

    public TestTrip()
    {
        TripName = string.Empty;
        Status = string.Empty;
        PrimaryDestination = string.Empty;
        ContactId = string.Empty;
		Image = string.Empty;
		Account = new();
		Traveler = new();
        Attributes = new();
		Destinations = new();
		PNRs = new();
    }
}

public class Account
{
    public string Id { get; set; }
    public string FullName { get; set; }

    public Account()
    {
        Id = string.Empty;
        FullName = string.Empty;
    }
}

public class Assignee
{
    public string Id { get; set; }
    public string FirstName { get; set; }
    public string MiddleName { get; set; }
    public string LastName { get; set; }

    public Assignee()
    {
        Id = string.Empty;
        FirstName = string.Empty;
        MiddleName = string.Empty;
        LastName = string.Empty;
    }
}

public class Request
{
    public string Id { get; set; }
    public string Version { get; set; }
    public bool IsAfterHours { get; set; }
    public bool HasSavedHours { get; set; }
    public int TripId { get; set; }

    public Request(string id, string version, bool isAfterHours, bool hasSavedHours, int tripId)
    {
        Id = id;
        Version = version;
        IsAfterHours = isAfterHours;
        HasSavedHours = hasSavedHours;
        TripId = tripId;
    }
}

public class Traveler
{
    public string Id { get; set; }
    public string ContactId { get; set; }
    public string BookedBy { get; set; }
    public string Email { get; set; }
    public string FirstName { get; set; }
    public string MiddleName { get; set; }
    public string LastName { get; set; }
    public bool IsActive { get; set; }
    public string? Type { get; set; }

    public Traveler()
    {
        Id = string.Empty;
        ContactId = string.Empty;
        BookedBy = string.Empty;
        Email = string.Empty;
        FirstName = string.Empty;
        MiddleName = string.Empty;
        LastName = string.Empty;
    }
}

public class TicketingSummary
{
    public bool WasEverFullyTicketed { get; set; }
    public bool WasEverPartiallyTicketed { get; set; }
    public bool IsFullyTicketed { get; set; }
    public bool IsPartiallyTicketed { get; set; }

    public TicketingSummary(bool wasEverFullyTicketed, bool wasEverPartiallyTicketed, bool isFullyTicketed, bool isPartiallyTicketed)
    {
        WasEverFullyTicketed = wasEverFullyTicketed;
        WasEverPartiallyTicketed = wasEverPartiallyTicketed;
        IsFullyTicketed = isFullyTicketed;
        IsPartiallyTicketed = isPartiallyTicketed;
    }
}

public class PNR
{
    public string Locator { get; set; }
    public string Status { get; set; }
    public string BookingType { get; set; }
    public List<Traveler> Travelers { get; set; }
    public List<string> OperatingAirlines { get; set; }

    public PNR(string locator, string status, string bookingType, List<Traveler> travelers, List<string> operatingAirlines)
    {
        Locator = locator;
        Status = status;
        BookingType = bookingType;
        Travelers = travelers;
        OperatingAirlines = operatingAirlines;
    }
}
