﻿namespace SfGridRefresh.Library.Extensions
{
    public static class DebounceExtension
    {
        private static Dictionary<string, CancellationTokenSource> _debounceTasks
            = new Dictionary<string, CancellationTokenSource>();

        public static Func<Task> Debounce(this Func<Task> func, int milliseconds = 300, string key = "")
        {
            return async () =>
            {
                if (_debounceTasks.TryGetValue(key, out var debounce))
                {
                    debounce.Cancel();
                    debounce.Dispose();
                    _debounceTasks.Remove(key);
                }

                var cts = new CancellationTokenSource();
                _debounceTasks[key] = cts;

                try
                {
                    await Task.Delay(milliseconds, cts.Token);
                    await func();
                }
                catch (TaskCanceledException) { }
                finally
                {
                    _debounceTasks.Remove(key);
                }
            };
        }
    }
}
