﻿using SfGridRefresh.Library.Models.Filter;
using SfGridRefresh.Shared.Models;
using Syncfusion.Blazor;
using Syncfusion.Blazor.Data;
using System.Text.Json;

namespace SfGridRefresh.Shared.Data
{
	public class TripsDataAdaptor : DataAdaptor
	{
		private List<TestTrip> _trips;
		private TripFilter _tripsFilter;

		public TripsDataAdaptor()
		{
			_trips = TripData.GetTrips();
			_tripsFilter = new TripFilter();
		}

		public override object Read(DataManagerRequest dataManagerRequest, string? additionalParam = null)
		{
			var tripGrid = _trips;

			tripGrid = FilterTrips(dataManagerRequest, tripGrid);

			DataResult dataResult = new()
			{
				Result = tripGrid
			};

			return dataResult;
		}

		private List<TestTrip> FilterTrips(DataManagerRequest dataManagerRequest, List<TestTrip> trips)
		{
			if (dataManagerRequest.Where?.Any() == true)
			{
				foreach (WhereFilter filter in dataManagerRequest.Where)
				{
					(filter.Field switch
					{
						"My Accounts" => () => _tripsFilter.AccountId = $"{filter.value}",
						"Travel Dates" => UpdateFilterDates($"{filter.value}"),
						"Trip Status" => UpdateListValues(_tripsFilter.TripStatuses, $"{filter.value}"),
						"Trip Type" => UpdateListValues(_tripsFilter.BookingTypes, $"{filter.value}"),
						_ => () => { }
					})();
				}

				return UpdateTrips(trips);
			}

			return trips;
		}

		private List<TestTrip> UpdateTrips(List<TestTrip> trips)
		{
			var tripQuery = trips.AsQueryable();

			if (!string.IsNullOrEmpty(_tripsFilter.AccountId))
			{
				tripQuery = tripQuery.Where(t => _tripsFilter.AccountId == t.Account.FullName).AsQueryable();
			}

			if (_tripsFilter.TripStatuses.Count > 0)
			{
				tripQuery = tripQuery.Where(t => _tripsFilter.TripStatuses.Contains(t.Status)).AsQueryable();
			}

			if (_tripsFilter.BookingTypes.Count > 0)
			{
				tripQuery = tripQuery.Where(t => t.Attributes.Any(a => _tripsFilter.BookingTypes.Contains(a))).AsQueryable();
			}

			if (_tripsFilter.StartDate is not null && _tripsFilter.EndDate is not null)
			{
				tripQuery = tripQuery.Where(t => t.StartDate.Date >= _tripsFilter.StartDate.Value.Date && t.EndDate.Date <= _tripsFilter.EndDate.Value.Date).AsQueryable();
			}

			return tripQuery.ToList();
		}

		private static Action UpdateListValues(List<string> list, string value)
		{
			list.Clear();

			if (!string.IsNullOrEmpty(value))
			{
				foreach (string v in value.Split(","))
					list.Add(v);
			}

			return () => { };
		}

		private Action UpdateFilterDates(string value)
		{
			var filterSection = JsonSerializer.Deserialize<FilterSection>(value);

			if (filterSection is not null)
			{
				_tripsFilter.StartDate = filterSection.StartDate;
				_tripsFilter.EndDate = filterSection.EndDate;
			}

			return () => { };
		}
	}
}
