﻿namespace SfGridRefresh.Shared.Models;

public static class TripData
{
    public static List<TestTrip> GetTrips()
    {
        int rowCount = 200;
        int tripId = 4001800;
        DateTime createdDate = DateTime.Now.AddMonths(2);

        string base64Image = "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";

        List<Account> accounts = new List<Account> {
            new Account
            {
                Id = "A6UJ9A0005RZ",
                FullName = "ADTRAV Business Travel"
            },
            new Account
            {
                Id = "A4E4BF7FB780",
                FullName = "ADTRAV RFW Demo Test"
            },
            new Account
            {
                Id = "A0C7284B7790",
                FullName = "Pacific Northwest National Laboratory"
            },
            new Account
            {
                Id = "AC5E18811A38",
                FullName = "Tetra Tech, Inc."
            },
            new Account
            {
                Id = "ACB7E0B15150",
                FullName = "AFL Global US"
            },
            new Account
            {
                Id = "A6UJ9A0008U6",
                FullName = "FINRA"
            },
            new Account
            {
                Id = "A6UJ9A0008W4",
                FullName = "Huntington Ingalls Industries"
            },
            new Account
            {
                Id = "A6UJ9A00076P",
                FullName = "Abeinsa"
            }
        };

        List<Traveler> travelers = new List<Traveler>
        {
            new Traveler
            {
                Id = "6399",
                ContactId = "C6UJ9A00M2O6",
                BookedBy = "C6UJ9A00M2O6",
                Email = "testbooking-william1@adtrav-rezdesk.com",
                FirstName = "William",
                MiddleName = "",
                LastName = "Never",
                IsActive = true,
                Type = "Caregiver"
            },
            new Traveler
            {
                Id = "1151497",
                ContactId = "C94E6A2D4AD4",
                BookedBy = "C94E6A2D4AD4",
                Email = "vasya.never@test.test",
                FirstName = "Vasya",
                MiddleName = "",
                LastName = "Never",
                IsActive = true,
                Type = "Companion"
            },
            new Traveler
            {
                Id = "1149348",
                ContactId = "C1B020D12C7D",
                BookedBy = "C1B020D12C7D",
                Email = "150167@test.com",
                FirstName = "Ben",
                MiddleName = "M",
                LastName = "Shelton",
                IsActive = true,
                Type = "Employee"
            },
            new Traveler
            {
                Id = "1008515",
                ContactId = "C1563FD62426",
                BookedBy = "C1563FD62426",
                Email = "323864@test.com",
                FirstName = "Angel",
                MiddleName = "N",
                LastName = "Never",
                IsActive = true,
                Type = "Patient"
            },
            new Traveler
            {
                Id = "370651",
                ContactId = "C4856DAFC92C",
                BookedBy = "C4856DAFC92C",
                Email = "674892@test.com",
                FirstName = "Concur",
                MiddleName = "W",
                LastName = "Tester",
                IsActive = true,
                Type = "Employee"
            },
            new Traveler
            {
                Id = "896699",
                ContactId = "CCB2DBEE6CC5",
                BookedBy = "CCB2DBEE6CC5",
                Email = "will.never123@tetratech.com",
                FirstName = "Will",
                MiddleName = "T",
                LastName = "Blake",
                IsActive = true,
                Type = "Other"
            },
            new Traveler
            {
                Id = "4542",
                ContactId = "C6UJ9A00WS8M",
                BookedBy = "C6UJ9A00WS8M",
                Email = "872570@test.com",
                FirstName = "Sam",
                MiddleName = "",
                LastName = "Sanderson",
                IsActive = true,
                Type = null
            },
            new Traveler
            {
                Id = "4004",
                ContactId = "C6UJ9A00JQ34",
                BookedBy = "C6UJ9A00JQ34",
                Email = "mike.maloof@abeinsaepc.abengoa.com",
                FirstName = "Mike",
                MiddleName = "Alan",
                LastName = "Maloof",
                IsActive = true,
                Type = "Caregiver"
            },
            new Traveler
            {
                Id = "4005",
                ContactId = "C6UJ9A00JQ35",
                BookedBy = "C6UJ9A00JQ35",
                Email = "caleb.wells@adtrav.com",
                FirstName = "Caleb",
                MiddleName = "Craig",
                LastName = "Wells",
                IsActive = true,
                Type = "Caregiver"
            },
            new Traveler
            {
                Id = "4007",
                ContactId = "C6UJ9A00JQ37",
                BookedBy = "C6UJ9A00JQ37",
                Email = "kevin.wells@adtrav.com",
                FirstName = "Kevin",
                MiddleName = "",
                LastName = "Wells",
                IsActive = true,
                Type = "Companion"
            },
            new Traveler
            {
                Id = "4006",
                ContactId = "C6UJ9A00JQ36",
                BookedBy = "C6UJ9A00JQ36",
                Email = "raman.rao@adtrav.com",
                FirstName = "Raman",
                MiddleName = "",
                LastName = "Rao",
                IsActive = true,
                Type = null
            }
        };

        string[] statuses = new[]
        {
            "Booked",
            "Canceled",
            "Completed",
            "Confirmed",
            "Ticketed"
        };

        string[] segments = new[]
        {
            "Air",
            "Car",
            "Ground",
            "Hotel",
            "Rail",
            "Sea"
        };

        string[] attributes = new[]
        {
            "Domestic",
            "International",
            "After Hours",
            "VIP",
            "Events"
        };

        string[] versions = new[]
        {
            "A",
            "B",
            "C",
            "D"
        };

        string[] destinations = new[]
        {
            "Birmingham, AL",
            "Atlanta, GA",
            "New Orleans, LA",
            "Detroit, MI",
            "San Francisco, CA",
            "New York, NY",
            "Chicago, IL",
            "Dallas, TX"
        };

        string[] airlines = new[]
        {
            "JB",
            "AA",
            "SW",
            "DL",
            "VA",
            "IA",
            "UA"
        };

        List<TestTrip> trips = new List<TestTrip>();

        for (int i = 0; i < rowCount; i++)
        {
            Random rand = new Random();
            int startDate = rand.Next(2, 7);
            int endDate = rand.Next(7, 10);

            var traveler = travelers[new Random().Next(travelers.Count)];

            var hasSegments = new List<string>();
            var seg = segments?.FirstOrDefault();
            if (seg != null)
            {
                hasSegments = new List<string> { seg };
            }
            var currentTrip = new TestTrip
            {
                TripID = tripId + i,
                RezID = tripId + i,
                TripName = $"Trip #{i + 1}",
                Status = statuses[new Random().Next(statuses.Length)],
                TripCreatedDate = createdDate.AddDays(i),
                StartDate = createdDate.AddDays(startDate),
                EndDate = createdDate.AddDays(endDate),
                PrimaryDestination = destinations[new Random().Next(destinations.Length)],
                Account = accounts[new Random().Next(accounts.Count)],
                Request = new Request($"{tripId + i}", versions[new Random().Next(versions.Length)], GetBoolean(rand), GetBoolean(rand), tripId + i),
                Traveler = traveler,
                RequestTravelers = new List<Traveler> { traveler },
                HasSegments = hasSegments,
                Attributes = GetBoolean(rand) ? new List<string>() : new List<string> { attributes[new Random().Next(attributes.Length)] },
                TicketingSummary = new TicketingSummary(GetBoolean(rand), GetBoolean(rand), GetBoolean(rand), GetBoolean(rand)),
                CreatedAt = createdDate.AddDays(i),
                ModifiedAt = GetBoolean(rand) ? createdDate.AddDays(startDate) : null,
                Approved = GetBoolean(rand)
            };

            currentTrip.ContactId = traveler.ContactId;

            currentTrip.Image = base64Image;

            if (GetBoolean(rand))
            {
                var companions = travelers.Where(t => t.ContactId != traveler.ContactId).ToList();
                currentTrip.RequestTravelers.Add(companions[new Random().Next(companions.Count)]);
            }

            currentTrip.TravelerCount = currentTrip.RequestTravelers.Count;

            if (GetBoolean(rand))
            {
                if (segments != null)
                {
                    var addSegment = segments.Skip(1).ToArray();
                    currentTrip.HasSegments.Add(addSegment[new Random().Next(addSegment.Length)]);
                }
            }

            currentTrip.Destinations = new List<string> { currentTrip.PrimaryDestination };

            if (GetBoolean(rand))
            {
                var addDestination = destinations.Where(d => d != currentTrip.PrimaryDestination).ToArray();
                currentTrip.Destinations.Add(addDestination[new Random().Next(addDestination.Length)]);
            }

            List<string> tripAirlines = new List<string> { airlines[new Random().Next(airlines.Length)] };

            currentTrip.PNRs = new List<PNR> { new PNR(GetPNR(rand), currentTrip.Status, "Agent", currentTrip.RequestTravelers, tripAirlines) };

            //if (GetBoolean(rand))
            //{
            //    currentTrip.PNRs.Add(new PNR(GetPNR(rand), statuses[new Random().Next(statuses.Length)], "Agent", currentTrip.RequestTravelers, tripAirlines));
            //}

            trips.Add(currentTrip);
        }

        return trips;
    }

    public static bool GetBoolean(Random rand)
    {
        return rand.NextDouble() >= 0.5;
    }

    public static string GetPNR(Random rand)
    {
        const string letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

        string pnr = new string(Enumerable.Repeat(letters, 6).Select(p => p[rand.Next(p.Length)]).ToArray());

        return pnr;
    }
}
