﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Runtime.CompilerServices;
using System.Windows;
using System.Windows.Input;
using Syncfusion.SfSkinManager;

namespace ThemedMenuTest
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            RegisterThemes("MaterialLight");
            RegisterThemes("MaterialDark");

            DataContext = this;

            ObservableCollection<MenuItemViewModel> children = new();

            children.Add(
                new MenuItemViewModel("Light")
                {
                    ExecuteAction = delegate (object? o)
                    {
                        SfSkinManager.SetVisualStyle(Application.Current.MainWindow, Syncfusion.SfSkinManager.VisualStyles.MaterialLight);
                    }
                }
            );

            children.Add(
                new MenuItemViewModel("Dark")
                {
                    ExecuteAction = delegate (object? o)
                    {
                        SfSkinManager.SetVisualStyle(Application.Current.MainWindow, Syncfusion.SfSkinManager.VisualStyles.MaterialDark);
                    }
                }
            );

            MenuItems1.Add(new MenuItemViewModel("The background color is not correct due to the presence of a style in the xaml") { MenuItems = children });
            MenuItems2.Add(new MenuItemViewModel("The colors in this menu are correct, but the layout is not as you'd expect from a menu") { MenuItems = children });

            SfSkinManager.ApplyStylesOnApplication = true;
        }

        public static void RegisterThemes(string style)
        {
            Type skinHelpterType = Type.GetType($"Syncfusion.Themes.{style}.WPF.{style}SkinHelper, Syncfusion.Themes.{style}.WPF");
            if (skinHelpterType != null)
            {
                SkinHelper styleInstance = Activator.CreateInstance(skinHelpterType) as SkinHelper;

                if (styleInstance != null)
                {
                    SfSkinManager.RegisterTheme(style, styleInstance);
                }
            }
        }

        public ObservableCollection<MenuItemViewModel> MenuItems1 { get; private set; } = new ObservableCollection<MenuItemViewModel>();
        public ObservableCollection<MenuItemViewModel> MenuItems2 { get; private set; } = new ObservableCollection<MenuItemViewModel>();
    }

    public class MenuItemViewModel : ICommand, INotifyPropertyChanged
    {
        public MenuItemViewModel(string title)
        {
            Header = title;
            Command = this;
        }

        public string Header { get; set; } = string.Empty;
        public string InputGesture { get; set; } = string.Empty;
        public bool IsEnabled { get; set; } = true;
        public ICommand Command { get; set; }

        public object CommandParameter { get; set; }

        public ObservableCollection<MenuItemViewModel> MenuItems { get; set; } = new ObservableCollection<MenuItemViewModel>();

        public event EventHandler? CanExecuteChanged;

        public void AddSeparator() => MenuItems.Add(new MenuItemViewModel("Separator"));

        public Predicate<object> CanExecutePredicate { get; set; }
        public Action<object> ExecuteAction { get; set; }

        public bool CanExecute(object? parameter) => CanExecutePredicate?.Invoke(CommandParameter) ?? true;
        public void Execute(object? parameter) => ExecuteAction?.Invoke(CommandParameter);
        public event PropertyChangedEventHandler? PropertyChanged;

        protected virtual bool SetProperty<T>(ref T storage, T value, [CallerMemberName] string propertyName = "")
        {
            if (EqualityComparer<T>.Default.Equals(storage, value))
            {
                return false;
            }
            storage = value;
            OnPropertyChanged(propertyName);
            return true;
        }

        protected virtual void OnPropertyChanged([CallerMemberName] string propertyName = null)
        {
            //Debug.WriteLine($"OnPropertyChanged: {propertyName ?? string.Empty}");
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }
    }
}
