namespace FZI_TestArea.Pages;

public class DropDownList3Objects
{
    public List<MainObject> MainObjects { get; set; }

    public List<SubObject> SubObjects { get; set; }

    public DropDownList3Objects()
    {
        SubObjects = GenerateListOfSubobjects();
        MainObjects = GenerateListOfMainObjects(SubObjects);
    }

    private List<MainObject> GenerateListOfMainObjects(List<SubObject> subObjects)
    {
        List<MainObject> mainObjects = new();

        for (int i = 1; i <= 4; i++)
        {
            mainObjects.Add(new MainObject()
            {
                Id = i,
                Name = $"Name{i}",
                SubObjectId = subObjects.Where(so => so.Id == (i * 2)).Single().Id,
                SubObject = subObjects.Where(so => so.Id == (i * 2)).Single(),
            });
        }

        return mainObjects;
    }

    private List<SubObject> GenerateListOfSubobjects()
    {
        List<SubObject> subObjects = new();

        for (int i = 1; i <= 8; i++)
        {
            subObjects.Add(new SubObject() { Id = i, Text = $"Text {i} blabla", AnotherField = $"{i * 2}_{i * 10}" });
        }

        return subObjects;
    }
}

public class MainObject
{
    public int Id { get; set; }

    public string Name { get; set; }

    public int SubObjectId { get; set; }

    public SubObject SubObject { get; set; }
}

public class SubObject
{
    public int Id { get; set; }

    public string Text { get; set; }

    public string AnotherField { get; set; }
}