import { Component,OnInit } from '@angular/core';
import { MaskedDateTimeService } from '@syncfusion/ej2-angular-calendars';
import { loadCldr,L10n } from '@syncfusion/ej2-base';

declare var require: any;


loadCldr(
      require('cldr-data/supplemental/numberingSystems.json'),
      require('cldr-data/main/de/ca-gregorian.json'),
      require('cldr-data/main/de/numbers.json'),
      require('cldr-data/main/de/currencies.json'),
      require('cldr-data/main/de/timeZoneNames.json'),
      require('cldr-data/supplemental/weekdata.json') 
  );

@Component({
  selector: 'app-root',
  // specifies the template string for the DropDownList component with change event
  // sets `German` culture using the culture value 'de'
  // sets the 'EUR' currency format

  providers: [MaskedDateTimeService],
  template: ` <ejs-datepicker locale="de" [format]="format" [enableMask]="enableMaskSupport"></ejs-datepicker>`
  
})
export class AppComponent implements OnInit {
  constructor() {
  }
  public format: string = 'M/d/yyyy';
  public enableMaskSupport: boolean = true;
  
  ngOnInit(): void {
      // Load `German` culture to override spin buttons tooltip text
      L10n.load({
          'de': {
          'datepicker': {
            placeholder: 'Wählen Sie ein Datum',
            today: 'heute',
              }
         }
      });
  }
}