﻿using System.Collections.ObjectModel;

namespace AutoCompleteSample;

public partial class MainPage : ContentPage
{
    ViewModel viewModel;
	public MainPage()
	{
		InitializeComponent();
        viewModel = new ViewModel();
        BindingContext = viewModel;
        autocomplete.ItemsSource = viewModel.Collection;
        listView.ItemsSource = viewModel.Collection;
    }

    private void autocomplete_Unfocused(object sender, FocusEventArgs e)
    {
        if(autocomplete.Text !=string.Empty && autocomplete.Text != null)
        {
            viewModel.Collection.Add(autocomplete.Text);
        }
    }
}

public class ViewModel
{
    public ObservableCollection<string> Collection { get; set; } = new ObservableCollection<string>();
    public ViewModel()
    {

    }
}
