import 'package:flutter/material.dart';
import 'package:syncfusion_flutter_charts/charts.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      theme: ThemeData(
        colorScheme: ColorScheme.fromSeed(seedColor: Colors.deepPurple),
        useMaterial3: true,
      ),
      home: const MyHomePage(),
    );
  }
}

class MyHomePage extends StatefulWidget {
  const MyHomePage({super.key});

  @override
  State<MyHomePage> createState() => _MyHomePageState();
}

class _MyHomePageState extends State<MyHomePage> {
  late List<ChartSampleData> _data;
  late TrackballBehavior _trackballBehavior;
  late TrackballBehavior _trackballBehavior1;

  @override
  void initState() {
    _data = <ChartSampleData>[
      ChartSampleData(10, 50),
      ChartSampleData(20, 60),
      ChartSampleData(30, 20),
      ChartSampleData(40, 10),
      ChartSampleData(50, 30),
      ChartSampleData(60, 40),
      ChartSampleData(70, 80),
      ChartSampleData(80, 90),
      ChartSampleData(90, 70),
      ChartSampleData(100, 50),
    ];
    _trackballBehavior = TrackballBehavior(
      enable: true,
      shouldAlwaysShow: true,
      activationMode: ActivationMode.singleTap,
      builder: (context, trackballDetails) {
        return Container(
          height: 20,
          width: 20,
          color: Colors.red,
        );
      },
    );
    _trackballBehavior1 = TrackballBehavior(
      enable: true,
      shouldAlwaysShow: true,
      activationMode: ActivationMode.singleTap,
    );
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: GestureDetector(
        onTap: () {
          _trackballBehavior.hide();
          _trackballBehavior1.hide();
        },
        child: Scaffold(
          body: SingleChildScrollView(
            child: Column(
              children: [
                SizedBox(
                  height: 200,
                  width: 500,
                  child: SfCartesianChart(
                    primaryXAxis: NumericAxis(),
                    primaryYAxis: NumericAxis(),
                    series: <CartesianSeries<ChartSampleData, num>>[
                      ColumnSeries<ChartSampleData, num>(
                        dataSource: _data,
                        xValueMapper: (ChartSampleData sales, int index) =>
                            sales.x,
                        yValueMapper: (ChartSampleData sales, int index) =>
                            sales.x,
                      ),
                    ],
                    trackballBehavior: _trackballBehavior,
                  ),
                ),
                const SizedBox(
                  height: 16,
                ),
                SizedBox(
                  height: 200,
                  width: 500,
                  child: SfCartesianChart(
                    primaryXAxis: NumericAxis(),
                    primaryYAxis: NumericAxis(),
                    series: <CartesianSeries<ChartSampleData, num>>[
                      ColumnSeries<ChartSampleData, num>(
                        dataSource: _data,
                        xValueMapper: (ChartSampleData sales, int index) =>
                            sales.x,
                        yValueMapper: (ChartSampleData sales, int index) =>
                            sales.x,
                      ),
                    ],
                    trackballBehavior: _trackballBehavior1,
                  ),
                ),
                Row(
                  children: [
                    TextButton(
                      onPressed: () {
                        _trackballBehavior.hide();
                      },
                      child: Text('Hide 1st series'),
                    ),
                    TextButton(
                      onPressed: () {
                        _trackballBehavior1.hide();
                      },
                      child: Text('Hide 2nd series'),
                    ),
                  ],
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }
}

class ChartSampleData {
  final num x;
  final num y;

  ChartSampleData(
    this.x,
    this.y,
  );
}
