import 'dart:math';

import 'package:flutter/material.dart';
import 'package:syncfusion_flutter_charts/charts.dart';

void main() => runApp(const MyApp());

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
        debugShowCheckedModeBanner: false,
        theme: ThemeData(
          primarySwatch: Colors.blue,
        ),
        home: const MainApp());
  }
}

class MainApp extends StatefulWidget {
  const MainApp({super.key});

  @override
  State<MainApp> createState() => _MainAppState();
}

class _MainAppState extends State<MainApp> {
  late List<ChartSampleData> _data;
  late TrackballBehavior _trackballBehavior;

  @override
  void initState() {
    _data = <ChartSampleData>[
      ChartSampleData(10, 50.000),
      ChartSampleData(20, 60.000),
      ChartSampleData(30, 20.000),
      ChartSampleData(40, 10.000),
      ChartSampleData(50, 30.000),
      ChartSampleData(60, 40.000),
      ChartSampleData(70, 80.000),
      ChartSampleData(80, 90.000),
      ChartSampleData(90, 70.000),
      ChartSampleData(100, 50.000),
    ];

    _trackballBehavior = TrackballBehavior(
      enable: true,
      shouldAlwaysShow: true,
      tooltipDisplayMode: TrackballDisplayMode.groupAllPoints,
      activationMode: ActivationMode.singleTap,
      tooltipSettings: const InteractiveTooltip(
        format: 'series.name: point.y',
      ),
    );
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      home: Scaffold(
        body: Center(
          child: SizedBox(
            height: 400,
            width: 500,
            child: SfCartesianChart(
              primaryXAxis: NumericAxis(),
              primaryYAxis: NumericAxis(),
              enableSideBySideSeriesPlacement: false,
              series: <CartesianSeries<ChartSampleData, num>>[
                ColumnSeries<ChartSampleData, num>(
                  dataSource: _data,
                  xValueMapper: (ChartSampleData sales, int index) => sales.x,
                  yValueMapper: (ChartSampleData sales, int index) => sales.y,
                ),
                ColumnSeries<ChartSampleData, num>(
                  dataSource: _data,
                  xValueMapper: (ChartSampleData sales, int index) => sales.x,
                  yValueMapper: (ChartSampleData sales, int index) =>
                      sales.y - Random().nextDouble() * 10,
                ),
              ],
              trackballBehavior: _trackballBehavior,
            ),
          ),
        ),
      ),
    );
  }
}

class ChartSampleData {
  final num x;
  final num y;

  ChartSampleData(this.x, this.y);
}
