﻿using Syncfusion.Maui.DataGrid;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TestGridResize
{
    public class DataGridBackgroundConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var dataGridRow = value as DataGridRow;

            if (dataGridRow.DataRow.RowIndex == 2)
            {
                if (dataGridRow.DataRow.IsSelectedRow)
                    return Colors.DarkRed;

                return Colors.Red;
            }

            if (dataGridRow.DataRow.IsSelectedRow)
                return Colors.DarkBlue;
            
            return Colors.LightBlue;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
