﻿using System;
using System.Collections.ObjectModel;
using System.ComponentModel;

namespace SfListViewIssue;

public class AutoPageViewModel: BindableBase
{
    public Command LoadMoreCommand { get; }
    public Command ReloadCommand { get; }
    public ObservableCollection<NameValue> ItemsSource { get; } = new ObservableCollection<NameValue>();

    private bool _IsLazyLoading;
    public bool IsLazyLoading
    {
        get => _IsLazyLoading;
        set => SetProperty(ref _IsLazyLoading, value);
    }

    private bool _HeaderVisible = false;
    public bool HeaderVisible
    {
        get => _HeaderVisible;
        set => SetProperty(ref _HeaderVisible, value);
    }

    public AutoPageViewModel()
    {
        LoadMoreCommand = new Command(async () =>
        {
            IsLazyLoading = true;
            var list = await GetItems();
            foreach(var item in list)
            {
                ItemsSource.Add(item);
            }

            IsLazyLoading = false;
        });

        ReloadCommand = new Command(async () =>
        {
            HeaderVisible = true;
            ItemsSource.Clear();
        });
    }

    async Task<List<NameValue>> GetItems()
    {
        if (ItemsSource.Count >= 30)
        {
            return new List<NameValue>();
        }

        await Task.Delay(1000);        

        var list = new List<NameValue>();
        for(var i = 0; i < 10; i++)
        {
            list.Add(CreateItem());
        }

        return list;
    }

    NameValue CreateItem()
    {
        var list = "abcdefghijklmnopqrstuvwxyz";
        var rand = new Random();

        var name = new string( list.OrderBy(x => rand.Next()).Take(6).ToArray());
        var value = rand.Next();

        return new NameValue
        {
            Name = name,
            Value = value,
        };

    }
}

public class NameValue
{
    public string Name { get; set; }
    public int Value { get; set; }
}

