﻿using Microsoft.AspNetCore.Http.Features;
using Microsoft.AspNetCore.Mvc;
using System.Net.Http.Headers;
using IHostingEnvironment = Microsoft.AspNetCore.Hosting.IHostingEnvironment;

namespace BlazFileUploader.Data
{
    [Route("api/[controller]")]
    public class SampleDataController : Controller
    {
        private readonly IWebHostEnvironment _hostingEnvironment;

        public SampleDataController(IWebHostEnvironment hostingEnvironment)
        {
            _hostingEnvironment = hostingEnvironment;
        }

        [HttpPost("[action]")]
        [DisableRequestSizeLimit]
        // "myFile" is the value of the Upload's "Name" property.
        public ActionResult Save(IFormFile UploadFiles)
        {
            try
            {

                var chunkIndex = HttpContext.Request.Form["chunk-index"];

                var totalChunk = HttpContext.Request.Form["total-chunk"];

                var authorization = HttpContext.Request.Headers["Authorization"];
                // Create the uploads directory if it doesn't exist. Path.Combine is used in the code to construct the file path for saving the uploaded file.
                var path = Path.Combine(_hostingEnvironment.WebRootPath, "uploads");
                if (!Directory.Exists(path))
                    Directory.CreateDirectory(path);
                // If the file does not exist, create it
                if (!System.IO.File.Exists(Path.Combine(path, UploadFiles.FileName)))
                {
                    using (var fileStream = System.IO.File.Create(Path.Combine(path, UploadFiles.FileName)))
                    {
                        UploadFiles.CopyTo(fileStream);
                    }
                }
                // If the file already exists, append to it
                else
                {
                    var filePath = Path.Combine(path, UploadFiles.FileName);
                    using (var fileStream = System.IO.File.Open(filePath, FileMode.Append))
                    {
                        UploadFiles.CopyTo(fileStream);
                        fileStream.Flush();
                    }
                }
            }
            catch
            {
                Response.StatusCode = 400;
            }
            return new EmptyResult();
        }

        [HttpPost("[action]")]
        public void Remove(string UploadFiles)
        {
            try
            {
                var path = Path.Combine(_hostingEnvironment.WebRootPath, "uploads", UploadFiles);
                if (System.IO.File.Exists(path))
                {
                    System.IO.File.Delete(path);
                }
            }
            catch (Exception e)
            {
                Response.Clear();
                Response.StatusCode = 200;
                Response.HttpContext.Features.Get<IHttpResponseFeature>().ReasonPhrase = "File removed successfully";
                Response.HttpContext.Features.Get<IHttpResponseFeature>().ReasonPhrase = e.Message;
            }
        }
        public IActionResult Index()
        {
            return View();
        }
    }
}
