import { createApp } from 'vue';
import App from './App.vue';
import { createI18n } from 'vue-i18n';

// Import the locale files
import en from './locales/en';
import es from './locales/es';
import pt from './locales/pt';

const messages = {
  en,
  es,
  pt,
};

const i18n = createI18n({
  locale: 'en', // Set your default locale here
  messages,
});

const app = createApp(App);
app.use(i18n);
app.mount('#app');
