﻿using Dummy.Models;
using GraphQL;
using GraphQL.Client.Abstractions;
using GraphQL.Client.Http;
using GraphQL.Client.Serializer.Newtonsoft;
using GraphQLParser;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using Syncfusion.EJ2.Base;
using System.Diagnostics;
using System.IdentityModel.Tokens.Jwt;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Resources;
using System.Text;
using static System.Net.Mime.MediaTypeNames;
using static System.Runtime.InteropServices.JavaScript.JSType;

namespace Dummy.Controllers
{
    public class HomeController : Controller
    {
        private readonly ILogger<HomeController> _logger;
        public static  string endpoint = "http://x3dev.endiprev.com:8124/xtrem/api/";
        GraphQLHttpClient client;


        public HomeController(ILogger<HomeController> logger)
        {
            _logger = logger;
        }

        public IActionResult Index()
        {
            List<ColumnData> chartData = new List<ColumnData>
            {
                new ColumnData {  Year=1, Primeiro = 120,  Segundo = 80, Terceiro = 40, Quarto = 20, Quinto = 20},
            };
            ViewBag.ChartPoints = chartData;


            ViewBag.DataPivot = new PivotTableData().GetDefaultData();


            ViewBag.dataSource = GanttData.MultiTaskbarData();
            ViewBag.projectResources = GanttData.MultitaskbarResource();

            return View();
        }

        public IActionResult Privacy()
        {
            return View();
        }
        public class ColumnData
        {
            public double Year;
            public double Primeiro;
            public double Segundo;
            public double Terceiro;
            public double Quarto;
            public double Quinto;
        }



        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}