import 'package:flutter/material.dart';
import 'package:syncfusion_flutter_charts/charts.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      theme: ThemeData(
        colorScheme: ColorScheme.fromSeed(seedColor: Colors.deepPurple),
        useMaterial3: true,
      ),
      home: const MyHomePage(),
    );
  }
}

class MyHomePage extends StatefulWidget {
  const MyHomePage({super.key});

  @override
  State<MyHomePage> createState() => _MyHomePageState();
}

class _MyHomePageState extends State<MyHomePage> {
  late List<ChartSampleData> _data;
  late List<int> yValue;
  ChartSeriesController? _chartSeriesController;
  int count = 2;

  @override
  void initState() {
    _data = [
      ChartSampleData(x: 01, y: 20),
      ChartSampleData(x: 02, y: 40),
    ];
    yValue = [
      20,
      40,
      60,
      30,
      70,
      40,
      80,
      50,
      10,
      90,
      50,
      20,
      40,
      70,
      40,
      80,
      60,
      40,
      90,
      20,
      80,
      60,
      80,
      70,
      40,
      60,
      90,
      30,
      60,
      100,
      10,
      20,
      80,
      40,
      60,
      30,
      40,
      50,
      80,
      70,
      30,
      50,
      30,
      30,
      60,
      80,
      30,
      20,
      10,
      40,
    ];

    // Timer.periodic(const Duration(seconds: 5), (Timer timer) {
    //   _realTimeUpdate();
    // });
    super.initState();
  }

  void _realTimeUpdate() {
    addData();
    if (_chartSeriesController != null) {
      _chartSeriesController!.updateDataSource(
        addedDataIndexes: [
          _data.length - 2,
          _data.length - 1,
        ],
      );
    }
  }

  void addData() {
    for (int i = 0; i < 2; i++) {
      if (count < yValue.length) {
        count++;
        _data.add(
          ChartSampleData(
            x: count,
            y: yValue[count - 1],
          ),
        );
      }
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: SfCartesianChart(
        primaryXAxis: NumericAxis(),
        primaryYAxis: NumericAxis(),
        series: <CartesianSeries<ChartSampleData, num>>[
          LineSeries(
            dataSource: _data,
            xValueMapper: (ChartSampleData sales, int index) => sales.x,
            yValueMapper: (ChartSampleData sales, int index) => sales.y,
            onRendererCreated: (controller) {
              _chartSeriesController = controller;
            },
            dataLabelMapper: (ChartSampleData sales, int index) =>
                sales.x.toString(),
            dataLabelSettings: const DataLabelSettings(isVisible: true),
          ),
        ],
      ),
      floatingActionButton: FloatingActionButton.small(
        onPressed: () {
          _realTimeUpdate();
        },
        child: const Icon(Icons.add),
      ),
    );
  }
}

class ChartSampleData {
  final num? x;
  final num? y;
  final num? low;
  final num? open;
  final num? close;

  ChartSampleData({
    this.x,
    this.y,
    this.low,
    this.open,
    this.close,
  });
}
