﻿using Newtonsoft.Json;
using Sample.DTO;

namespace SyncfusionCascadingDDLSample.Services
{
    public class API
    {
        public async Task<Response<List<ScheduledJobDetailsDTO>>> GetCurrentlyScheduledJobs()
        {
            string json = string.Empty;
            using (StreamReader sr = File.OpenText(@".\Data\currentlyScheduledJobs.json"))
            {
                json = sr.ReadToEnd();
            }
            Response<List<ScheduledJobDetailsDTO>> scheduledJobs = JsonConvert.DeserializeObject<Response<List<ScheduledJobDetailsDTO>>>(json, new JsonSerializerSettings() { NullValueHandling = NullValueHandling.Ignore });
            return scheduledJobs;
        }

        public async Task<Response<List<VenueDTO>>> GetUserVenues()
        {
            string json = string.Empty;
            using (StreamReader sr = File.OpenText(@".\Data\userVenues.json"))
            {
                json = sr.ReadToEnd();
            }
            Response<List<VenueDTO>> venues = JsonConvert.DeserializeObject<Response<List<VenueDTO>>>(json, new JsonSerializerSettings() { NullValueHandling = NullValueHandling.Ignore });
            return venues;
        }

        public async Task<Response<List<VenueDTO>>> GetLevel1Venues()
        {
            string json = string.Empty;
            using (StreamReader sr = File.OpenText(@".\Data\level1data.json"))
            {
                json = sr.ReadToEnd();
            }
            Response<List<VenueDTO>> venues = JsonConvert.DeserializeObject<Response<List<VenueDTO>>>(json, new JsonSerializerSettings() { NullValueHandling = NullValueHandling.Ignore });
            return venues;
        }

        public async Task<Response<List<VenueDTO>>> GetLevel2Venues()
        {
            string json = string.Empty;
            using (StreamReader sr = File.OpenText(@".\Data\level2data.json"))
            {
                json = sr.ReadToEnd();
            }
            Response<List<VenueDTO>> venues = JsonConvert.DeserializeObject<Response<List<VenueDTO>>>(json, new JsonSerializerSettings() { NullValueHandling = NullValueHandling.Ignore });
            return venues;
        }

        public async Task<Response<List<VenueDTO>>> GetLevel3Venues()
        {
            string json = string.Empty;
            using (StreamReader sr = File.OpenText(@".\Data\level3data.json"))
            {
                json = sr.ReadToEnd();
            }
            Response<List<VenueDTO>> venues = JsonConvert.DeserializeObject<Response<List<VenueDTO>>>(json, new JsonSerializerSettings() { NullValueHandling = NullValueHandling.Ignore });
            return venues;
        }

        public async Task<Response<List<VenueLevelDTO>>> GetVenueHiearchy(int venueUKey)
        {
            string json = string.Empty;
            if (venueUKey == -1)
            {
                using (StreamReader sr = File.OpenText(@".\Data\emptyData.json"))
                {
                    json = sr.ReadToEnd();
                }
            }
            else if (venueUKey == 1870)
            {
                using (StreamReader sr = File.OpenText(@".\Data\hierarchyData.json"))
                {
                    json = sr.ReadToEnd();
                }
            }

            Response<List<VenueLevelDTO>> hiearchy = JsonConvert.DeserializeObject<Response<List<VenueLevelDTO>>>(json, new JsonSerializerSettings() { NullValueHandling = NullValueHandling.Ignore });
            return hiearchy;
        }

        public List<LocationModel> RetrieveParentsOfUkey(int venueUKey)
        {
            List<LocationModel> result = new List<LocationModel>();
            if (venueUKey == 4611)
            {
                result.Add(new LocationModel { levelUkey = 1870 });
            }
            else if (venueUKey == 3033)
            {
                result.Add(new LocationModel { levelUkey = 2976 });
                result.Add(new LocationModel { levelUkey = 4611 });
                result.Add(new LocationModel { levelUkey = 1870 });
            }
            return result;
        }
    }
}
