using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using Microsoft.UI.Xaml;
using Microsoft.UI.Xaml.Controls;
using Microsoft.UI.Xaml.Controls.Primitives;
using Microsoft.UI.Xaml.Data;
using Microsoft.UI.Xaml.Input;
using Microsoft.UI.Xaml.Media;
using Microsoft.UI.Xaml.Navigation;
using Windows.Foundation;
using Windows.Foundation.Collections;


namespace SfDataGridSortBug;

public class Data
{
    public int? Priority
    {
        get; set;
    }

    public string? PriorityText
    {
        get => Priority != null ? $"#{Priority}" : null;
    }

    public string Text
    {
        get; set;
    }

    public ObservableCollection<Data> ChildTasks = new();

    public Data(int? priority, string text)
    {
        Priority = priority;
        Text = text;
    }

    public Data(int? priority, string text, ObservableCollection<Data> childTasks)
    {
        Priority = priority;
        Text = text;
        ChildTasks = childTasks;
    }
}

public class ComparerNullAfterValues : IComparer<object>
{
    public int Compare(object x, object y)
    {
        if (x is Data left && y is Data right)
        {
            if (left.Priority != null && right.Priority != null)
            {
                return left.Priority.Value - right.Priority.Value;
            }
            else if (left.Priority != null)
            {
                return -1;
            }
            else if (right.Priority != null)
            {
                return 1;
            }
        }
        return 0;
    }
}


public sealed partial class MainWindow : Window
{
    private ObservableCollection<Data> Data = new();

    public MainWindow()
    {
        this.InitializeComponent();
    }

    private void Grid_Loaded(object sender, RoutedEventArgs e)
    {
        Data.Clear();
        Data.Add(new(null, "A"));
        Data.Add(new(null, "B"));
        Data.Add(new(3, "C"));
        Data.Add(new(null, "D"));
        Data.Add(new(1, "E"));

        ObservableCollection<Data> sub = new()
        {
            new(null, "G"),
            new(4, "H")
        };
        Data.Add(new(2, "F", sub));
    }
}
