﻿using RichTextEditor.Client.Models;
using Syncfusion.Blazor.DropDowns;
using Syncfusion.Blazor.RichTextEditor;

namespace RichTextEditor.Client.Pages;

partial class Index
{
    private readonly static List<ToolbarItemModel> _items = new()
    {
        new ToolbarItemModel() { Command = ToolbarCommand.Bold },
        new ToolbarItemModel() { Command = ToolbarCommand.Italic },
        new ToolbarItemModel() { Command = ToolbarCommand.Underline },
        new ToolbarItemModel() { Command = ToolbarCommand.Separator },
        new ToolbarItemModel() { Command = ToolbarCommand.Formats },
        new ToolbarItemModel() { Command = ToolbarCommand.Alignments },
        new ToolbarItemModel() { Command = ToolbarCommand.OrderedList },
        new ToolbarItemModel() { Command = ToolbarCommand.UnorderedList },
        new ToolbarItemModel() { Command = ToolbarCommand.Separator },
        new ToolbarItemModel() { Command = ToolbarCommand.CreateLink },
        new ToolbarItemModel() { Command = ToolbarCommand.Image },
        new ToolbarItemModel() { Command = ToolbarCommand.Separator },
        new ToolbarItemModel() { Command = ToolbarCommand.SourceCode },
        new ToolbarItemModel() { Command = ToolbarCommand.Undo },
        new ToolbarItemModel() { Command = ToolbarCommand.Redo }
    };

    private readonly List<Mention> _mentions = new()
    {
        new() { Id = "Test" }
    };
    private Mention? _newField;

    public string? EditorValue { get; set; }
    public IEnumerable<Mention> Mentions => _mentions;

    // Why doesn't the following work?
    /*private void OnFiltering(MentionFilteringEventArgs<Mention> args)
    {
        if (string.IsNullOrEmpty(args.Text) || args.FilteredData.Any(m => m.Id == args.Text))
        {
            return;
        }

        if (_newField is null)
        {
            _newField = new Mention()
            {
                CreateNew = true,
                Id = args.Text
            };
        }
        else
        {
            _newField.Id = args.Text;
        }
        args.FilteredData = args.FilteredData.Append(_newField);
    }*/

    // I have to do the following instead
    private void OnFiltering(MentionFilteringEventArgs<Mention> args)
    {
        if (string.IsNullOrEmpty(args.Text) || _mentions.Any(m => m.Id == args.Text))
        {
            if (_newField is not null)
            {
                _mentions.Remove(_newField);
            }
            return;
        }

        if (_newField is null)
        {
            _newField = new Mention()
            {
                CreateNew = true,
                Id = args.Text
            };
        }
        else
        {
            _newField.Id = args.Text;
        }

        if (!_mentions.Contains(_newField))
        {
            _mentions.Add(_newField);
        }
    }

    private void OnValueSelecting(MentionValueSelectingEventArgs<Mention> args)
    {
        if (string.IsNullOrEmpty(args.ItemData.Id))
        {
            args.Cancel = true;
        }
        if (args.ItemData.CreateNew)
        {
            args.ItemData.CreateNew = false;
            _newField = null;
        }
    }
}
