﻿using System.IO;
using System.Windows.Controls;
using System.Windows.Markup;
using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace XamlReportsTest;

public class Report<T>
{
    private readonly string _path = Path.Combine("D:", "Bin", "Reports");
    private readonly string _input;
    private readonly string _output;

    public Report()
    {
        string name = typeof(T).Name;
        Console.WriteLine($"Load report '{name}'");

        _input = Path.Combine("Reports", $"{name}Report.xaml");
        _output = Path.Combine(_path, $"{name}Report.pdf");
    }

    public async Task Render(T context)
    {
        await Console.Out.WriteLineAsync("Rendering PDF...");
        const int scale = 4;

        using FileStream fs = File.OpenRead(_input);
        Page visual = (Page)XamlReader.Load(fs);
        visual.BeginInit();
        visual.DataContext = context;
        visual.Arrange(new(new(819, 1056)));
        visual.EndInit();
        visual.UpdateLayout();

        RenderTargetBitmap bitmap = new(819 * scale, 1056 * scale, 96 * scale, 96 * scale, PixelFormats.Pbgra32);
        bitmap.Render(visual);

        TiffBitmapEncoder encoder = new();
        encoder.Frames.Add(BitmapFrame.Create(bitmap));

        using FileStream writer = File.Create(_output + ".tif");
        encoder.Save(writer);
    }
}
