﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
using System.Windows;

namespace RibbonOfficeSample.WPFUtilities
{
    public class WindowClosingBehavior
    {
        public static ICommand GetClosed(DependencyObject obj)
        {
            return (ICommand)obj.GetValue(ClosedProperty);
        }

        public static void SetClosed(DependencyObject obj, ICommand value)
        {
            obj.SetValue(ClosedProperty, value);
        }

        public static ICommand GetClosing(DependencyObject obj)
        {
            return (ICommand)obj.GetValue(ClosingProperty);
        }

        public static void SetClosing(DependencyObject obj, ICommand value)
        {
            obj.SetValue(ClosingProperty, value);
        }

        public static ICommand GetCancelClosing(DependencyObject obj)
        {
            return (ICommand)obj.GetValue(CancelClosingProperty);
        }

        public static void SetCancelClosing(DependencyObject obj, ICommand value)
        {
            obj.SetValue(CancelClosingProperty, value);
        }

        public static readonly DependencyProperty ClosedProperty =
            DependencyProperty.RegisterAttached("Closed",
                                                typeof(ICommand),
                                                typeof(WindowClosingBehavior),
                                                new UIPropertyMetadata(OnClosedChanged));

        public static readonly DependencyProperty ClosingProperty =
            DependencyProperty.RegisterAttached("Closing",
                                                typeof(ICommand),
                                                typeof(WindowClosingBehavior),
                                                new UIPropertyMetadata(OnClosingChanged));

        public static readonly DependencyProperty CancelClosingProperty =
            DependencyProperty.RegisterAttached("CancelClosing",
                                                typeof(ICommand),
                                                typeof(WindowClosingBehavior));

        private static void OnClosedChanged(DependencyObject dependencyObject,
            DependencyPropertyChangedEventArgs dependencyPropertyChangedEventArgs)
        {
            if (!(dependencyObject is Window window))
                return;

            if (dependencyPropertyChangedEventArgs.NewValue != null)
            {
                window.Closed += WindowOnClosed;
            }
            else
            {
                window.Closed -= WindowOnClosed;
            }
        }

        private static void WindowOnClosed(object sender, EventArgs eventArgs)
        {
            var command = GetClosed(sender as Window);

            command?.Execute(null);
        }

        private static void OnClosingChanged(DependencyObject dependencyObject,
            DependencyPropertyChangedEventArgs dependencyPropertyChangedEventArgs)
        {
            if (!(dependencyObject is Window window))
                return;

            if (dependencyPropertyChangedEventArgs.NewValue != null)
            {
                window.Closing += WindowOnClosing;
            }
            else
            {
                window.Closing -= WindowOnClosing;
            }
        }

        private static void WindowOnClosing(object sender, CancelEventArgs cancelEventArgs)
        {
            if (!(sender is Window window))
                return;

            var closingCommand = GetClosing(window);

            if (closingCommand == null)
                return;

            if (closingCommand.CanExecute(null))
            {
                closingCommand.Execute(null);
            }
            else
            {
                var cancelClosingCommand = GetCancelClosing(window);

                cancelClosingCommand?.Execute(null);

                cancelEventArgs.Cancel = true;
            }
        }
    }
}
