﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows;

namespace RibbonOfficeSample.WPFUtilities
{
    /// <summary>
    /// Interaction logic for SplitView.xaml
    /// </summary>
    public class SplitView : Grid
    {
        private class ContentControlEx : ContentControl
        {
            //FIXME whaaa? how does this fix anything?! (terrain tab issue)
        }

        protected override void OnChildDesiredSizeChanged(UIElement child)
        {
            base.OnChildDesiredSizeChanged(child);
        }

        protected override void OnInitialized(EventArgs e)
        {
            base.OnInitialized(e);
        }

        private readonly ContentControl _fixedViewArea;
        private readonly ContentControl _fillViewArea;

        public SplitView()
        {
            RowDefinitions.Add(new RowDefinition { Height = GridLength.Auto });
            RowDefinitions.Add(new RowDefinition());

            _fixedViewArea = new ContentControl();
            SetRow(_fixedViewArea, 0);
            Children.Add(_fixedViewArea);

            _fillViewArea = new ContentControlEx();
            SetRow(_fillViewArea, 1);
            Children.Add(_fillViewArea);
        }

        public static readonly DependencyProperty FixedViewProperty = DependencyProperty.Register(
              nameof(FixedView),
              typeof(object),
              typeof(SplitView),
              new FrameworkPropertyMetadata(null, FrameworkPropertyMetadataOptions.AffectsRender, OnFixedViewChanged)
            );

        private static void OnFixedViewChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            if (d is SplitView container)
            {
                if (e.NewValue is FrameworkElement child)
                {
                    var binding = new Binding(nameof(DataContext))
                    {
                        Source = container,
                        Mode = BindingMode.OneWay
                    };
                    BindingOperations.SetBinding(child, DataContextProperty, binding);
                }
                container._fixedViewArea.Content = e.NewValue;
            }
        }

        public object FixedView
        {
            get => GetValue(FixedViewProperty);
            set => SetValue(FixedViewProperty, value);
        }


        public static readonly DependencyProperty FillViewProperty = DependencyProperty.Register(
              nameof(FillView),
              typeof(object),
              typeof(SplitView),
              new FrameworkPropertyMetadata(null, FrameworkPropertyMetadataOptions.AffectsRender, OnFillViewChanged)
            );

        private static void OnFillViewChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            if (d is SplitView container)
            {
                if (e.NewValue is FrameworkElement child)
                {
                    var binding = new Binding(nameof(DataContext))
                    {
                        Source = container,
                        Mode = BindingMode.OneWay
                    };
                    BindingOperations.SetBinding(child, DataContextProperty, binding);
                }
                container._fillViewArea.Content = e.NewValue;
            }
        }

        public object FillView
        {
            get => GetValue(FillViewProperty);
            set => SetValue(FillViewProperty, value);
        }



        public static readonly DependencyProperty FixLocationProperty = DependencyProperty.Register(
              nameof(FixLocation),
              typeof(Location),
              typeof(SplitView),
              new FrameworkPropertyMetadata(Location.Top, FrameworkPropertyMetadataOptions.AffectsRender, new PropertyChangedCallback(OnFixLocationChanged))
            );

        private static void OnFixLocationChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            var container = d as SplitView;
            var value = (Location)e.NewValue;
            if (container != null)
            {
                container.RowDefinitions.Clear();
                container.ColumnDefinitions.Clear();
                switch (value)
                {
                    case Location.Top:
                        container.RowDefinitions.Add(new RowDefinition() { Height = GridLength.Auto });
                        container.RowDefinitions.Add(new RowDefinition() { Height = new GridLength(1, GridUnitType.Star) });
                        SetRow(container._fixedViewArea, 0);
                        SetRow(container._fillViewArea, 1);
                        break;
                    case Location.Bottom:
                        container.RowDefinitions.Add(new RowDefinition() { Height = new GridLength(1, GridUnitType.Star) });
                        container.RowDefinitions.Add(new RowDefinition() { Height = GridLength.Auto });
                        SetRow(container._fillViewArea, 0);
                        SetRow(container._fixedViewArea, 1);
                        break;

                    case Location.Left:
                        container.ColumnDefinitions.Add(new ColumnDefinition() { Width = GridLength.Auto });
                        container.ColumnDefinitions.Add(new ColumnDefinition() { Width = new GridLength(1, GridUnitType.Star) });
                        SetColumn(container._fixedViewArea, 0);
                        SetColumn(container._fillViewArea, 1);
                        break;
                    case Location.Right:
                        container.ColumnDefinitions.Add(new ColumnDefinition() { Width = new GridLength(1, GridUnitType.Star) });
                        container.ColumnDefinitions.Add(new ColumnDefinition() { Width = GridLength.Auto });
                        SetColumn(container._fillViewArea, 0);
                        SetColumn(container._fixedViewArea, 1);
                        break;
                }
            }
        }

        public Location FixLocation
        {
            get => (Location)GetValue(FixLocationProperty);
            set => SetValue(FixLocationProperty, value);
        }
    }

    public enum Location
    {
        Top,
        Bottom,
        Left,
        Right
    }
}
